/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.display;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import net.minecraft.nbt.CompoundNBT;

public class DisplaySerializerRegistryImpl
implements DisplaySerializerRegistry {
    private final Map<CategoryIdentifier<?>, DisplaySerializer<?>> serializers = new HashMap();

    @Override
    public <D extends Display> void register(CategoryIdentifier<? extends D> categoryId, DisplaySerializer<D> serializer) {
        this.serializers.put(categoryId, serializer);
    }

    @Override
    public <D extends Display> void registerNotSerializable(CategoryIdentifier<D> categoryId) {
        this.serializers.remove(categoryId);
    }

    @Override
    public <D extends Display> boolean hasSerializer(CategoryIdentifier<D> categoryId) {
        return this.serializers.containsKey(categoryId);
    }

    @Override
    public <D extends Display> CompoundNBT save(D display, CompoundNBT tag) {
        CategoryIdentifier<?> categoryId = display.getCategoryIdentifier();
        return Objects.requireNonNull(this.serializers.get(categoryId), "Category " + categoryId + " does not have a display serializer!").save(tag, display);
    }

    @Override
    public <D extends Display> D read(CategoryIdentifier<? extends D> categoryId, CompoundNBT tag) {
        return (D)Objects.requireNonNull(this.serializers.get(categoryId), "Category " + categoryId + " does not have a display serializer!").read(tag);
    }

    @Override
    public void startReload() {
        this.serializers.clear();
    }

    @Override
    public void acceptPlugin(REIPlugin<?> plugin) {
        plugin.registerDisplaySerializer(this);
    }
}

