/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import org.jetbrains.annotations.Nullable;

public class InputSlotCrafter<T extends Container, C extends IInventory, D extends Display>
implements MenuInfoContext<T, ServerPlayerEntity, D> {
    protected CategoryIdentifier<D> category;
    protected T container;
    protected D display;
    protected MenuInfo<T, D> menuInfo;
    private Iterable<SlotAccessor> inputStacks;
    private Iterable<SlotAccessor> inventoryStacks;
    private ServerPlayerEntity player;

    private InputSlotCrafter(CategoryIdentifier<D> category, T container) {
        this.category = category;
        this.container = container;
    }

    public void setDisplay(D display) {
        this.display = display;
    }

    public void setMenuInfo(MenuInfo<T, D> menuInfo) {
        this.menuInfo = menuInfo;
    }

    public static <T extends Container, C extends IInventory, D extends Display> InputSlotCrafter<T, C, D> start(CategoryIdentifier<D> category, T menu, ServerPlayerEntity player, CompoundNBT display, boolean hasShift) {
        InputSlotCrafter<T, C, D> crafter = new InputSlotCrafter<T, C, D>(category, menu);
        MenuInfo<T, D> menuInfo = Objects.requireNonNull(MenuInfoRegistry.getInstance().get(category, menu, crafter, display), "Container Info does not exist on the server!");
        crafter.setMenuInfo(menuInfo);
        crafter.setDisplay(menuInfo.read(crafter, display));
        super.fillInputSlots(player, hasShift);
        return crafter;
    }

    private void fillInputSlots(ServerPlayerEntity player, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.menuInfo.getInventorySlots(this);
        this.inputStacks = this.menuInfo.getInputSlots(this);
        this.cleanInputs();
        RecipeFinder recipeFinder = new RecipeFinder();
        this.menuInfo.getRecipeFinderPopulator().populate(this, recipeFinder);
        NonNullList ingredients = NonNullList.func_191196_a();
        for (List<ItemStack> itemStacks : this.menuInfo.getInputs(this, true)) {
            ingredients.add((Object)CollectionUtils.toIngredient(itemStacks));
        }
        if (!recipeFinder.findRecipe((NonNullList<Ingredient>)ingredients, null)) {
            this.cleanInputs();
            this.menuInfo.markDirty(this);
            throw new NotEnoughMaterialsException();
        }
        this.fillInputSlots(recipeFinder, (NonNullList<Ingredient>)ingredients, hasShift);
        this.menuInfo.markDirty(this);
    }

    public void alignRecipeToGrid(Iterable<SlotAccessor> inputStacks, Iterator<Integer> recipeItemIds, int craftsAmount) {
        for (SlotAccessor inputStack : inputStacks) {
            if (!recipeItemIds.hasNext()) {
                return;
            }
            this.acceptAlignedInput(recipeItemIds.next(), inputStack, craftsAmount);
        }
    }

    public void acceptAlignedInput(Integer recipeItemId, SlotAccessor inputStack, int craftsAmount) {
        ItemStack toBeTakenStack = RecipeFinder.getStackFromId(recipeItemId);
        if (!toBeTakenStack.func_190926_b()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(inputStack, toBeTakenStack);
            }
        }
    }

    protected void fillInputSlot(SlotAccessor slot, ItemStack toBeTakenStack) {
        ItemStack takenStack;
        SlotAccessor takenSlot = this.takeInventoryStack(toBeTakenStack);
        if (takenSlot != null && !(takenStack = takenSlot.getItemStack().func_77946_l()).func_190926_b()) {
            if (takenStack.func_190916_E() > 1) {
                takenSlot.takeStack(1);
            } else {
                takenSlot.setItemStack(ItemStack.field_190927_a);
            }
            takenStack.func_190920_e(1);
            if (slot.getItemStack().func_190926_b()) {
                slot.setItemStack(takenStack);
            } else {
                slot.getItemStack().func_190917_f(1);
            }
        }
    }

    protected void fillInputSlots(RecipeFinder recipeFinder, NonNullList<Ingredient> ingredients, boolean hasShift) {
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, null);
        IntArrayList recipeItemIds = new IntArrayList();
        int amountToFill = hasShift ? recipeCrafts : 1;
        if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, amountToFill)) {
            int finalCraftsAmount = amountToFill;
            IntListIterator intListIterator = recipeItemIds.iterator();
            while (intListIterator.hasNext()) {
                int itemId = (Integer)intListIterator.next();
                finalCraftsAmount = Math.min(finalCraftsAmount, RecipeFinder.getStackFromId(itemId).func_77976_d());
            }
            if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, finalCraftsAmount)) {
                this.cleanInputs();
                this.alignRecipeToGrid(this.inputStacks, (Iterator<Integer>)recipeItemIds.iterator(), finalCraftsAmount);
            }
        }
    }

    protected void cleanInputs() {
        this.menuInfo.getInputCleanHandler().clean(this);
    }

    @Nullable
    public SlotAccessor takeInventoryStack(ItemStack itemStack) {
        for (SlotAccessor inventoryStack : this.inventoryStacks) {
            ItemStack itemStack1 = inventoryStack.getItemStack();
            if (itemStack1.func_190926_b() || !InputSlotCrafter.areItemsEqual(itemStack, itemStack1) || itemStack1.func_77951_h() || itemStack1.func_77948_v() || itemStack1.func_82837_s()) continue;
            return inventoryStack;
        }
        return null;
    }

    private static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    @Override
    public T getMenu() {
        return this.container;
    }

    @Override
    public ServerPlayerEntity getPlayerEntity() {
        return this.player;
    }

    @Override
    public MenuInfo<T, D> getContainerInfo() {
        return this.menuInfo;
    }

    @Override
    public D getDisplay() {
        return this.display;
    }

    @Override
    public CategoryIdentifier<D> getCategoryIdentifier() {
        return this.category;
    }

    public static class NotEnoughMaterialsException
    extends RuntimeException {
    }
}

