/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.transfer;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JEIRecipeTransferData<C extends Container> {
    private final ResourceLocation recipeCategoryUid;
    private final List<Slot> recipeSlots;
    private final List<Slot> inventorySlots;
    private final boolean requireCompleteSets;

    public JEIRecipeTransferData(ResourceLocation recipeCategoryUid, List<Slot> recipeSlots, List<Slot> inventorySlots, boolean requireCompleteSets) {
        this.recipeCategoryUid = recipeCategoryUid;
        this.recipeSlots = recipeSlots;
        this.inventorySlots = inventorySlots;
        this.requireCompleteSets = requireCompleteSets;
    }

    @OnlyIn(value=Dist.CLIENT)
    public JEIRecipeTransferData(IRecipeTransferInfo<C> info, C container) {
        this(info.getRecipeCategoryUid(), info.getRecipeSlots(container), info.getInventorySlots(container), info.requireCompleteSets());
    }

    public static <C extends Container> JEIRecipeTransferData<C> read(C menu, CompoundNBT tag) {
        ResourceLocation recipeCategoryUid = ResourceLocation.func_208304_a((String)tag.func_74779_i("recipeCategoryUid"));
        List<Slot> recipeSlots = JEIRecipeTransferData.readSlots(menu, tag.func_150295_c("recipeSlots", 10));
        List<Slot> inventorySlots = JEIRecipeTransferData.readSlots(menu, tag.func_150295_c("inventorySlots", 10));
        boolean requireCompleteSets = tag.func_74767_n("requireCompleteSets");
        return new JEIRecipeTransferData<C>(recipeCategoryUid, recipeSlots, inventorySlots, requireCompleteSets);
    }

    public CompoundNBT save(CompoundNBT tag) {
        tag.func_74778_a("recipeCategoryUid", this.recipeCategoryUid.toString());
        tag.func_218657_a("recipeSlots", (INBT)this.writeSlots(this.recipeSlots));
        tag.func_218657_a("inventorySlots", (INBT)this.writeSlots(this.inventorySlots));
        tag.func_74757_a("requireCompleteSets", this.requireCompleteSets);
        return tag;
    }

    public static <C extends Container> List<Slot> readSlots(C menu, ListNBT tag) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (INBT entry : tag) {
            slots.add(menu.func_75139_a(((CompoundNBT)entry).func_74762_e("Index")));
        }
        return slots;
    }

    public ListNBT writeSlots(List<Slot> slots) {
        ListNBT listTag = new ListNBT();
        for (Slot slot : slots) {
            CompoundNBT entry = new CompoundNBT();
            entry.func_74768_a("Index", slot.field_75222_d);
            listTag.add((Object)entry);
        }
        return listTag;
    }

    public ResourceLocation getRecipeCategoryUid() {
        return this.recipeCategoryUid;
    }

    public List<Slot> getRecipeSlots() {
        return this.recipeSlots;
    }

    public List<Slot> getInventorySlots() {
        return this.inventorySlots;
    }

    public boolean isRequireCompleteSets() {
        return this.requireCompleteSets;
    }
}

