/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredientManager;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIVanillaRecipeFactory;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class JEIRecipeRegistration
implements IRecipeRegistration {
    private final List<Runnable> post;

    public JEIRecipeRegistration(List<Runnable> post) {
        this.post = post;
    }

    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IIngredientManager getIngredientManager() {
        return JEIIngredientManager.INSTANCE;
    }

    @Override
    @NotNull
    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        return JEIVanillaRecipeFactory.INSTANCE;
    }

    @Override
    public void addRecipes(@NotNull Collection<?> recipes, @NotNull ResourceLocation categoryId) {
        this.post.add(() -> {
            CategoryIdentifier categoryIdentifier = CategoryIdentifier.of(categoryId);
            DisplayRegistry registry = DisplayRegistry.getInstance();
            if (recipes instanceof List && recipes.size() >= 100) {
                this.addRecipesOptimized((List)recipes, categoryIdentifier, registry);
                return;
            }
            for (Object recipe : recipes) {
                Collection<Display> displays = registry.tryFillDisplay(recipe);
                for (Display display : displays) {
                    if (!Objects.equals(display.getCategoryIdentifier(), categoryIdentifier)) continue;
                    registry.add(display, recipe);
                }
            }
        });
    }

    private void addRecipesOptimized(List<Object> recipes, @NotNull CategoryIdentifier<?> categoryId, DisplayRegistry registry) {
        ArrayList completableFutures = Lists.newArrayList();
        Function<Object, Collection> tryFillDisplay = registry::tryFillDisplay;
        CollectionUtils.partition(recipes, 50).forEach(list -> completableFutures.add(CompletableFuture.supplyAsync(() -> CollectionUtils.map(list, tryFillDisplay))));
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        int i = 0;
        for (CompletableFuture future : completableFutures) {
            List displayCollection = future.getNow(null);
            if (displayCollection != null) {
                int j = 0;
                for (Collection displays : displayCollection) {
                    Object origin = recipes.get(i * 50 + j);
                    for (Display display : displays) {
                        if (!Objects.equals(display.getCategoryIdentifier(), categoryId)) continue;
                        registry.add(display, origin);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public <T> void addIngredientInfo(@NotNull T ingredient, @NotNull IIngredientType<T> ingredientType, String ... descriptionKeys) {
        EntryStack<T> stack = JEIPluginDetector.unwrapStack(ingredient, ingredientType);
        BuiltinClientPlugin.getInstance().registerInformation(stack, stack.asFormattedText(), components -> {
            for (String key : descriptionKeys) {
                components.add(new TranslationTextComponent(key));
            }
            return components;
        });
    }

    @Override
    public <T> void addIngredientInfo(@NotNull T ingredient, @NotNull IIngredientType<T> ingredientType, ITextComponent ... descriptionComponents) {
        EntryStack<T> stack = JEIPluginDetector.unwrapStack(ingredient, ingredientType);
        BuiltinClientPlugin.getInstance().registerInformation(stack, stack.asFormattedText(), components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }

    @Override
    public <T> void addIngredientInfo(@NotNull List<T> ingredients, @NotNull IIngredientType<T> ingredientType, String ... descriptionKeys) {
        EntryIngredient ingredient = JEIPluginDetector.unwrapList(ingredientType, ingredients);
        BuiltinClientPlugin.getInstance().registerInformation(ingredient, (ITextComponent)ImmutableTextComponent.EMPTY, components -> {
            for (String key : descriptionKeys) {
                components.add(new TranslationTextComponent(key));
            }
            return components;
        });
    }

    @Override
    public <T> void addIngredientInfo(@NotNull List<T> ingredients, @NotNull IIngredientType<T> ingredientType, ITextComponent ... descriptionComponents) {
        EntryIngredient ingredient = JEIPluginDetector.unwrapList(ingredientType, ingredients);
        BuiltinClientPlugin.getInstance().registerInformation(ingredient, (ITextComponent)ImmutableTextComponent.EMPTY, components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }
}

