/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCategoryHandler
implements TransferHandler {
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        Display display = context.getDisplay();
        ContainerScreen<?> containerScreen = context.getContainerScreen();
        if (containerScreen == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        Container menu = context.getMenu();
        MenuInfo<Container, Display> menuInfo = MenuInfoRegistry.getInstance().getClient(display, menu);
        if (menuInfo == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        MenuInfoContext<Container, PlayerEntity, Display> menuInfoContext = DefaultCategoryHandler.ofContext(menu, menuInfo, display);
        try {
            menuInfo.validate(menuInfoContext);
        }
        catch (MenuTransferException e) {
            if (e.isApplicable()) {
                return TransferHandler.Result.createFailed(e.getError());
            }
            return TransferHandler.Result.createNotApplicable();
        }
        List<InputIngredient<ItemStack>> input = menuInfo.getInputsIndexed(menuInfoContext, false);
        List<InputIngredient<ItemStack>> missing = this.hasItemsIndexed(menu, menuInfo, display, input);
        if (!missing.isEmpty()) {
            IntArrayList missingIndices = new IntArrayList(missing.size());
            for (InputIngredient<ItemStack> ingredient : missing) {
                missingIndices.add(ingredient.getIndex());
            }
            IntLinkedOpenHashSet missingIndicesSet = new IntLinkedOpenHashSet((IntCollection)missingIndices);
            List<List> oldInputs = CollectionUtils.map(input, InputIngredient::get);
            return TransferHandler.Result.createFailed((ITextComponent)new TranslationTextComponent("error.rei.not.enough.materials")).renderer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> DefaultCategoryHandler.lambda$handle$0(menuInfo, menuInfoContext, oldInputs, (IntList)missingIndices, input, missing, (IntSet)missingIndicesSet, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((ITextComponent)new TranslationTextComponent("error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().func_147108_a(containerScreen);
        if (containerScreen instanceof IRecipeShownListener) {
            ((IRecipeShownListener)containerScreen).func_194310_f().field_191915_z.func_192682_a();
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_192572_a(display.getCategoryIdentifier().getIdentifier());
        buf.writeBoolean(context.isStackedCrafting());
        buf.func_150786_a(menuInfo.save(menuInfoContext, display));
        NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, (PacketBuffer)buf);
        return TransferHandler.Result.createSuccessful();
    }

    @Override
    public double getPriority() {
        return -10.0;
    }

    private static MenuInfoContext<Container, PlayerEntity, Display> ofContext(final Container menu, final MenuInfo<Container, Display> info, final Display display) {
        return new MenuInfoContext<Container, PlayerEntity, Display>(){

            @Override
            public Container getMenu() {
                return menu;
            }

            @Override
            public PlayerEntity getPlayerEntity() {
                return Minecraft.func_71410_x().field_71439_g;
            }

            @Override
            public MenuInfo<Container, Display> getContainerInfo() {
                return info;
            }

            @Override
            public CategoryIdentifier<Display> getCategoryIdentifier() {
                return display.getCategoryIdentifier();
            }

            @Override
            public Display getDisplay() {
                return display;
            }
        };
    }

    public IntList hasItems(Container menu, MenuInfo<Container, Display> info, Display display, List<List<ItemStack>> inputs) {
        List<InputIngredient<ItemStack>> missing = this.hasItemsIndexed(menu, info, display, CollectionUtils.mapIndexed(inputs, InputIngredient::of));
        IntArrayList ids = new IntArrayList(missing.size());
        for (InputIngredient<ItemStack> ingredient : missing) {
            ids.add(ingredient.getIndex());
        }
        return ids;
    }

    public List<InputIngredient<ItemStack>> hasItemsIndexed(Container menu, MenuInfo<Container, Display> info, Display display, List<InputIngredient<ItemStack>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        info.getRecipeFinderPopulator().populate(DefaultCategoryHandler.ofContext(menu, info, display), recipeFinder);
        ArrayList<InputIngredient<ItemStack>> missing = new ArrayList<InputIngredient<ItemStack>>();
        for (InputIngredient<ItemStack> possibleStacks : inputs) {
            boolean done = possibleStacks.get().isEmpty();
            for (ItemStack possibleStack : possibleStacks.get()) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.func_190916_E(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            missing.add(possibleStacks);
        }
        return missing;
    }

    private static /* synthetic */ void lambda$handle$0(MenuInfo menuInfo, MenuInfoContext menuInfoContext, List oldInputs, IntList missingIndices, List input, List missing, IntSet missingIndicesSet, MatrixStack matrices, int mouseX, int mouseY, float delta, List widgets, Rectangle bounds, Display d) {
        menuInfo.renderMissingInput(menuInfoContext, oldInputs, missingIndices, matrices, mouseX, mouseY, delta, widgets, bounds);
        menuInfo.renderMissingInput(menuInfoContext, input, missing, missingIndicesSet, matrices, mouseX, mouseY, delta, widgets, bounds);
    }
}

