/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import java.beans.ConstructorProperties;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.SizeValidators;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class MaximumSizeValidator
implements ISizeValidator {
    private final Vector3i maximumSize;

    @Override
    public ITextComponent isSizeValid(Vector3i size) {
        if (SizeValidators.compareVec3i(size, this.getMaximumSize()) <= 0) {
            return null;
        }
        return new TranslationTextComponent("multiblock.cyclopscore.error.size.max", new Object[]{LocationHelpers.toCompactString(size), LocationHelpers.toCompactString(this.getMaximumSize())});
    }

    @ConstructorProperties(value={"maximumSize"})
    public MaximumSizeValidator(Vector3i maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Vector3i getMaximumSize() {
        return this.maximumSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaximumSizeValidator)) {
            return false;
        }
        MaximumSizeValidator other = (MaximumSizeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3i this$maximumSize = this.getMaximumSize();
        Vector3i other$maximumSize = other.getMaximumSize();
        return !(this$maximumSize == null ? other$maximumSize != null : !this$maximumSize.equals(other$maximumSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaximumSizeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3i $maximumSize = this.getMaximumSize();
        result = result * 59 + ($maximumSize == null ? 0 : $maximumSize.hashCode());
        return result;
    }

    public String toString() {
        return "MaximumSizeValidator(maximumSize=" + this.getMaximumSize() + ")";
    }
}

