/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionForge;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class BlockAction
extends ConfigurableTypeActionForge<BlockConfig, Block> {
    private static final List<BlockConfig> MODEL_ENTRIES = Lists.newArrayList();

    public static void register(@Nullable BiFunction<BlockConfig, Block, ? extends Item> itemBlockConstructor, BlockConfig config, @Nullable Callable<?> callback) {
        BlockAction.register(config, itemBlockConstructor == null ? callback : null);
        if (itemBlockConstructor != null) {
            FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, event -> {
                Item itemBlock = (Item)itemBlockConstructor.apply(config, (Block)config.getInstance());
                Objects.requireNonNull(itemBlock, "Received a null item for the item block constructor of " + config.getNamedId());
                if (itemBlock.getRegistryName() == null) {
                    itemBlock.setRegistryName(new ResourceLocation(config.getMod().getModId(), config.getNamedId()));
                }
                event.getRegistry().register((IForgeRegistryEntry)itemBlock);
                config.setItemInstance(itemBlock);
                try {
                    if (callback != null) {
                        callback.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @Override
    public void onRegisterForge(BlockConfig eConfig) {
        BlockAction.register(eConfig.getItemConstructor(), eConfig, () -> {
            eConfig.onForgeRegistered();
            this.polish(eConfig);
            return null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelRegistryEvent event) {
        for (BlockConfig config : MODEL_ENTRIES) {
            Pair<ModelResourceLocation, ModelResourceLocation> resourceLocations = config.registerDynamicModel();
            config.dynamicBlockVariantLocation = (ModelResourceLocation)resourceLocations.getLeft();
            config.dynamicItemVariantLocation = (ModelResourceLocation)resourceLocations.getRight();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelBakeEvent event) {
        for (BlockConfig config : MODEL_ENTRIES) {
            IDynamicModelElement dynamicModelElement = (IDynamicModelElement)config.getInstance();
            IBakedModel dynamicModel = dynamicModelElement.createDynamicModel(event);
            if (config.dynamicBlockVariantLocation != null) {
                event.getModelRegistry().put(config.dynamicBlockVariantLocation, dynamicModel);
            }
            if (config.dynamicItemVariantLocation == null) continue;
            event.getModelRegistry().put(config.dynamicItemVariantLocation, dynamicModel);
        }
    }

    public static void handleDynamicBlockModel(BlockConfig extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(BlockConfig config) {
        IBlockColor blockColorHandler;
        Block block = (Block)config.getInstance();
        if (MinecraftHelpers.isClientSide() && (blockColorHandler = config.getBlockColorHandler()) != null) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(blockColorHandler, new Block[]{block});
        }
    }

    static {
        if (MinecraftHelpers.isClientSide()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(BlockAction::onModelRegistryLoad);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(BlockAction::onModelBakeEvent);
        }
    }
}

