/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LootHelpers {
    private static final LootHelpers INSTANCE = new LootHelpers();
    private static final Multimap<ResourceLocation, ResourceLocation> INJECT_LOOTTABLES = MultimapBuilder.ListMultimapBuilder.hashKeys().arrayListValues().build();

    private LootHelpers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        for (ResourceLocation injectTable : INJECT_LOOTTABLES.get((Object)event.getName())) {
            LootHelpers.injectLootTableDirect(event.getTable(), injectTable);
        }
    }

    public static void injectLootTable(ResourceLocation source, ResourceLocation ... targets) {
        for (ResourceLocation target : targets) {
            INJECT_LOOTTABLES.put((Object)target, (Object)source);
        }
    }

    public static void injectLootTableDirect(LootTable target, ResourceLocation source) {
        target.addPool(new LootPool.Builder().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)source)).name(source.toString()).func_216044_b());
    }

    public static LootFunctionType registerFunction(ResourceLocation id, ILootSerializer<? extends ILootFunction> serializer) {
        return (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)id, (Object)new LootFunctionType(serializer));
    }

    public static LootConditionType registerCondition(ResourceLocation id, ILootSerializer<? extends ILootCondition> serializer) {
        return (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)id, (Object)new LootConditionType(serializer));
    }
}

