/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.cyclops.cyclopscore.CyclopsCore;

public class MinecraftHelpers {
    public static final int MINECRAFT_DAY = 24000;
    public static final int COMPARATOR_MULTIPLIER = 15;
    public static final int SECOND_IN_TICKS = 20;
    public static final int BLOCK_NOTIFY = 1;
    public static final int BLOCK_NOTIFY_CLIENT = 2;
    public static final int BLOCK_NOTIFY_NO_RERENDER = 4;

    public static void setDay(ServerWorld world, boolean toDay) {
        int currentTime = (int)world.func_82737_E();
        int newTime = currentTime - currentTime % 12000 + 12000;
        ((IServerWorldInfo)world.func_72912_H()).func_82572_b((long)newTime);
    }

    public static boolean isPlayerInventoryFull(PlayerEntity player) {
        return player.field_71071_by.func_70447_i() == -1;
    }

    public static boolean isDevEnvironment() {
        return "mcp".equals(Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.NAMING.get()).orElse("mojang"));
    }

    public static boolean isMinecraftInitialized() {
        return CyclopsCore._instance.isLoaded();
    }

    public static String getMinecraftVersion() {
        return MCPVersion.getMCVersion();
    }

    public static String getMinecraftVersionMajorMinor() {
        return String.join((CharSequence)".", Arrays.asList(MinecraftHelpers.getMinecraftVersion().split("\\.")).subList(0, 2));
    }

    public static boolean isModdedEnvironment() {
        return MinecraftHelpers.class.getClassLoader() instanceof TransformingClassLoader;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isShifted() {
        return Screen.func_231173_s_();
    }

    public static int compareBlockPos(BlockPos pos1, BlockPos pos2) {
        int compX = Integer.compare(pos1.func_177958_n(), pos2.func_177958_n());
        if (compX == 0) {
            int compY = Integer.compare(pos1.func_177956_o(), pos2.func_177956_o());
            if (compY == 0) {
                return Integer.compare(pos1.func_177952_p(), pos2.func_177952_p());
            }
            return compY;
        }
        return compX;
    }

    public static <T> ActionResult<T> successAction(T result) {
        return new ActionResult(ActionResultType.SUCCESS, result);
    }

    public static boolean isClientSide() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isClientSideThread() {
        return MinecraftHelpers.isClientSide() && Minecraft.func_71410_x().field_71441_e != null && Thread.currentThread() == Minecraft.func_71410_x().field_71441_e.field_217407_c;
    }
}

