/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.HyperLink;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.packet.RequestPlayerNbtPacket;

public abstract class ScreenInfoBook<T extends ContainerExtended>
extends ContainerScreen<T> {
    private static final int HR_WIDTH = 88;
    private static final int HR_HEIGHT = 10;
    private static final int BANNER_WIDTH = 91;
    private static final int BANNER_HEIGHT = 12;
    private static final int ARROW_WIDTH = 22;
    private static final int ARROW_HEIGHT = 13;
    private static final int BORDER_CORNER = 4;
    private static final int BORDER_WIDTH = 2;
    private static final int BORDER_X = 0;
    private static final int BORDER_Y = 206;
    protected final IInfoBook infoBook;
    protected final ResourceLocation texture;
    protected NextPageButton buttonNextPage;
    protected NextPageButton buttonPreviousPage;
    protected NextPageButton buttonParent;
    protected NextPageButton buttonBack;
    protected NextPageButton buttonExternal;
    private InfoSection nextSection;
    private int nextPage;
    private boolean goToLastPage;
    private int left;
    private int top;

    public ScreenInfoBook(T container, PlayerInventory playerInventory, ITextComponent title, IInfoBook infoBook) {
        super(container, playerInventory, title);
        this.infoBook = infoBook;
        this.texture = this.constructGuiTexture();
        if (infoBook.getCurrentSection() == null) {
            InfoSection root = infoBook.getMod().getRegistryManager().getRegistry(IInfoBookRegistry.class).getRoot(infoBook);
            if (root == null) {
                throw new IllegalStateException("Could not find the root of infobook " + infoBook);
            }
            infoBook.setCurrentSection(root);
            infoBook.setCurrentPage(0);
        }
        CyclopsCore._instance.getPacketHandler().sendToServer(new RequestPlayerNbtPacket());
    }

    protected abstract ResourceLocation constructGuiTexture();

    protected int getPages() {
        return this.infoBook.getPagesPerView();
    }

    protected abstract int getGuiWidth();

    protected abstract int getGuiHeight();

    protected abstract int getPageWidth();

    protected int getPageYOffset() {
        return 16;
    }

    protected int getFootnoteOffsetX() {
        return 10;
    }

    protected int getFootnoteOffsetY() {
        return 0;
    }

    protected int getPrevNextOffsetY() {
        return 0;
    }

    protected int getPrevNextOffsetX() {
        return 0;
    }

    public int getTitleColor() {
        return Helpers.RGBToInt(120, 20, 30);
    }

    public void func_231160_c_() {
        int page;
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.left = (this.field_230708_k_ - this.getGuiWidth()) / 2;
        this.top = (this.field_230709_l_ - this.getGuiHeight()) / 2;
        this.buttonNextPage = new NextPageButton(this.left + this.getPageWidth() + 100 + this.getPrevNextOffsetX(), this.top + 156 + this.getPrevNextOffsetY(), 0, 180, 18, 10, button -> {
            InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, MinecraftHelpers.isShifted());
            this.goToLastPage = false;
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.func_230480_a_((Widget)this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(this.left + 23 - this.getPrevNextOffsetX(), this.top + 156 + this.getPrevNextOffsetY(), 0, 193, 18, 10, button -> {
            InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), MinecraftHelpers.isShifted());
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.goToLastPage = this.nextSection != this.infoBook.getCurrentSection() && !MinecraftHelpers.isShifted();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.func_230480_a_((Widget)this.buttonPreviousPage);
        this.buttonParent = new NextPageButton(this.left + 2, this.top + 2, 36, 180, 8, 8, button -> {
            this.goToLastPage = false;
            if (MinecraftHelpers.isShifted()) {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
                while (this.nextSection.getParent() != null) {
                    this.nextSection = this.nextSection.getParent();
                }
            } else {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
            }
            this.nextPage = 0;
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.func_230480_a_((Widget)this.buttonParent);
        this.buttonBack = new NextPageButton(this.left + this.getPageWidth() + 127, this.top + 2, 0, 223, 13, 18, button -> {
            InfoSection.Location location = this.infoBook.getHistory().pop();
            this.goToLastPage = false;
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.applyNavigation();
        }, this);
        this.func_230480_a_((Widget)this.buttonBack);
        this.buttonExternal = new NextPageButton(this.left + 130, this.top, 26, 203, 11, 11, button -> Helpers.openUrl(this.infoBook.getBaseUrl() + this.infoBook.getCurrentSection().getRelativeWebPath()), this);
        this.func_230480_a_((Widget)this.buttonExternal);
        this.updateGui();
        if (this.goToLastPage) {
            page = Math.max(0, this.infoBook.getCurrentSection().getPages() - this.getPages());
            page += page % this.getPages();
            this.infoBook.setCurrentPage(page);
        }
        for (int innerPage = page = this.infoBook.getCurrentPage(); innerPage <= page + this.getPages() - 1; ++innerPage) {
            for (HyperLink link : this.infoBook.getCurrentSection().getLinks(innerPage)) {
                if (link.getTranslationKey().equals(L10NHelpers.localize(link.getTranslationKey(), new Object[0]))) {
                    CyclopsCore.clog(Level.WARN, "Could not find hyperlink localization for " + link.getTranslationKey());
                }
                int xOffset = this.getOffsetXForPageWithWidths(innerPage % this.getPages());
                this.func_230480_a_((Widget)new TextOverlayButton(link, this.left + xOffset + link.getX(), this.top + this.getPageYOffset() / 2 + link.getY(), InfoSection.getFontHeight(this.getFontRenderer()), this.getPageWidth() - this.getOffsetXTotal() - link.getX(), button -> {
                    this.goToLastPage = false;
                    this.nextSection = ((TextOverlayButton)button).getLink().getTarget();
                    this.nextPage = 0;
                    if (this.nextSection != this.infoBook.getCurrentSection()) {
                        this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
                    }
                    this.applyNavigation();
                }, this));
            }
            for (AdvancedButton advancedButton : this.infoBook.getCurrentSection().getAdvancedButtons(innerPage)) {
                advancedButton.setOnPress(button -> {
                    this.goToLastPage = false;
                    this.nextSection = ((AdvancedButton)button).getTarget();
                    this.nextPage = 0;
                    if (this.nextSection != this.infoBook.getCurrentSection()) {
                        this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
                    }
                    this.applyNavigation();
                });
                this.func_230480_a_((Widget)advancedButton);
            }
        }
    }

    protected abstract int getOffsetXForPageBase(int var1);

    protected int getOffsetXForPageWithWidths(int page) {
        return this.getOffsetXForPageBase(page) + page * this.getPageWidth();
    }

    protected int getOffsetXTotal() {
        int total = 0;
        for (int i = 0; i < this.getPages(); ++i) {
            total += this.getOffsetXForPageBase(i);
        }
        return total;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        RenderHelpers.bindTexture(this.texture);
        this.func_238474_b_(matrixStack, this.left, this.top, 0, 0, this.getPageWidth(), this.getGuiHeight());
        this.blitMirrored(this.left + this.getPageWidth() - 1, this.top, 0, 0, this.getPageWidth(), this.getGuiHeight());
        int width = this.getPageWidth() - this.getOffsetXTotal();
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().drawScreen(this, matrixStack, this.left + this.getOffsetXForPageWithWidths(i), this.top, this.getPageYOffset(), width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, mouseX, mouseY, this.getFootnoteOffsetX(), this.getFootnoteOffsetY());
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().postDrawScreen(this, matrixStack, this.left + this.getOffsetXForPageWithWidths(i), this.top + this.getPageYOffset(), width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, mouseX, mouseY);
        }
        if (this.buttonNextPage.field_230694_p_ && RenderHelpers.isPointInButton(this.buttonNextPage, mouseX, mouseY)) {
            this.drawTooltip(matrixStack, mouseX, mouseY, (ITextComponent)new TranslationTextComponent("infobook.cyclopscore.next_page"));
        }
        if (this.buttonPreviousPage.field_230694_p_ && RenderHelpers.isPointInButton(this.buttonPreviousPage, mouseX, mouseY)) {
            this.drawTooltip(matrixStack, mouseX, mouseY, (ITextComponent)new TranslationTextComponent("infobook.cyclopscore.previous_page"));
        }
        if (this.buttonBack.field_230694_p_ && RenderHelpers.isPointInButton(this.buttonBack, mouseX, mouseY)) {
            this.drawTooltip(matrixStack, mouseX, mouseY, (ITextComponent)new TranslationTextComponent("infobook.cyclopscore.last_page"));
        }
        if (this.buttonParent.field_230694_p_ && RenderHelpers.isPointInButton(this.buttonParent, mouseX, mouseY)) {
            this.drawTooltip(matrixStack, mouseX, mouseY, (ITextComponent)new TranslationTextComponent("infobook.cyclopscore.parent_section"));
        }
        if (this.buttonExternal.field_230694_p_ && RenderHelpers.isPointInButton(this.buttonExternal, mouseX, mouseY)) {
            this.drawTooltip(matrixStack, mouseX, mouseY, (ITextComponent)new TranslationTextComponent("infobook.cyclopscore.external"));
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    public void drawTooltip(MatrixStack matrixStack, int mx, int my, ITextComponent lines) {
        GlStateManager.func_227626_N_();
        this.func_238652_a_(matrixStack, lines, mx, my);
        GlStateManager.func_227627_O_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
    }

    public void blitMirrored(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_225582_a_((double)(x + 0), (double)(y + height), (double)this.func_230927_p_()).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        worldRenderer.func_225582_a_((double)(x + width), (double)(y + height), (double)this.func_230927_p_()).func_225583_a_((float)(u + 0) * f, (float)(v + height) * f1).func_181675_d();
        worldRenderer.func_225582_a_((double)(x + width), (double)(y + 0), (double)this.func_230927_p_()).func_225583_a_((float)(u + 0) * f, (float)(v + 0) * f1).func_181675_d();
        worldRenderer.func_225582_a_((double)(x + 0), (double)(y + 0), (double)this.func_230927_p_()).func_225583_a_((float)(u + width) * f, (float)(v + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public int getBannerWidth() {
        return 91;
    }

    private void updateGui() {
        int width = this.getPageWidth() - this.getOffsetXTotal();
        int lineHeight = InfoSection.getFontHeight(this.getFontRenderer());
        int maxLines = (this.getGuiHeight() - 2 * this.getPageYOffset() - 5) / lineHeight;
        LinkedList infoSectionsToBake = Lists.newLinkedList();
        infoSectionsToBake.add(this.infoBook.getCurrentSection());
        this.getPreviousSections(infoSectionsToBake);
        this.getNextSections(infoSectionsToBake);
        for (InfoSection infoSection : infoSectionsToBake) {
            if (infoSection == null) continue;
            infoSection.bakeSection(this.getFontRenderer(), width, maxLines, lineHeight, this.getPageYOffset());
        }
        this.updateButtons();
    }

    protected void getPreviousSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    protected void getNextSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    private void updateButtons() {
        InfoSection.Location current1 = new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection());
        InfoSection.Location current2 = new InfoSection.Location(this.infoBook.getCurrentPage() + this.getPages() - 1, this.infoBook.getCurrentSection());
        InfoSection.Location wouldBeNext = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        this.buttonNextPage.field_230694_p_ = !current1.equals(wouldBeNext) && !current2.equals(wouldBeNext);
        this.buttonPreviousPage.field_230694_p_ = !current1.equals(this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false));
        this.buttonParent.field_230694_p_ = this.infoBook.getCurrentSection() != null && this.infoBook.getCurrentSection().getParent() != null;
        this.buttonBack.field_230694_p_ = this.infoBook.getHistory().currentSize() > 0;
    }

    protected void applyNavigation() {
        if (this.nextSection != null && (this.nextSection != this.infoBook.getCurrentSection() || this.infoBook.getCurrentPage() != this.nextPage)) {
            this.infoBook.setCurrentSection(this.nextSection);
            this.nextSection = null;
            this.infoBook.setCurrentPage(this.nextPage);
            this.func_231160_c_();
        }
    }

    public void drawScaledCenteredString(MatrixStack matrixStack, String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        this.drawScaledCenteredString(matrixStack, string, x, y, width, originalScale, maxWidth, color, false);
    }

    public void drawScaledCenteredString(MatrixStack matrixStack, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow) {
        float originalWidth = (float)this.getFontRenderer().func_78256_a(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(matrixStack, string, x, y, width, scale, color, shadow);
    }

    public void drawScaledCenteredString(MatrixStack matrixStack, String string, int x, int y, int width, float scale, int color) {
        this.drawScaledCenteredString(matrixStack, string, x, y, width, scale, color, false);
    }

    public void drawScaledCenteredString(MatrixStack matrixStack, String string, int x, int y, int width, float scale, int color, boolean shadow) {
        GlStateManager.func_227626_N_();
        GlStateManager.func_227672_b_((float)scale, (float)scale, (float)1.0f);
        int titleLength = this.field_230712_o_.func_78256_a(string);
        this.field_230712_o_.getClass();
        int titleHeight = 9;
        if (shadow) {
            this.field_230712_o_.func_238405_a_(matrixStack, string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, string, (float)Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), (float)Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        }
        GlStateManager.func_227627_O_();
    }

    public void drawHorizontalRule(MatrixStack matrixStack, int x, int y) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelpers.bindTexture(this.texture);
        this.func_238474_b_(matrixStack, x - 44, y - 5, 52, 180, 88, 10);
        GlStateManager.func_227737_l_();
    }

    public void drawTextBanner(MatrixStack matrixStack, int x, int y) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelpers.bindTexture(this.texture);
        this.func_238474_b_(matrixStack, x - 45, y - 6, 52, 191, 91, 12);
        GlStateManager.func_227737_l_();
    }

    public void drawArrowRight(MatrixStack matrixStack, int x, int y) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelpers.bindTexture(this.texture);
        this.func_238474_b_(matrixStack, x, y, 0, 210, 22, 13);
        GlStateManager.func_227737_l_();
    }

    public void drawOuterBorder(MatrixStack matrixStack, int x, int y, int width, int height) {
        this.drawOuterBorder(matrixStack, x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawOuterBorder(MatrixStack matrixStack, int x, int y, int width, int height, float r, float g, float b, float alpha) {
        int i;
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
        GlStateManager.func_227702_d_((float)r, (float)g, (float)b, (float)alpha);
        RenderHelpers.bindTexture(this.texture);
        this.func_238474_b_(matrixStack, x - 2, y - 2, 0, 206, 4, 4);
        this.func_238474_b_(matrixStack, x + width - 2, y - 2, 4, 206, 4, 4);
        this.func_238474_b_(matrixStack, x - 2, y + height - 2, 12, 206, 4, 4);
        this.func_238474_b_(matrixStack, x + width - 2, y + height - 2, 8, 206, 4, 4);
        for (i = 2; i < width - 2; i += 2) {
            int drawWidth = 2;
            if (i + 2 >= width - 4) {
                drawWidth -= i - (width - 4);
            }
            this.func_238474_b_(matrixStack, x + i, y - 2, 16, 206, drawWidth, 2);
            this.func_238474_b_(matrixStack, x + i, y + height, 16, 206, drawWidth, 2);
        }
        for (i = 2; i < height - 2; i += 2) {
            int drawHeight = 2;
            if (i + 2 >= height - 4) {
                drawHeight -= i - (height - 4);
            }
            if (drawHeight <= 0) continue;
            this.func_238474_b_(matrixStack, x - 2, y + i, 16, 206, 2, drawHeight);
            this.func_238474_b_(matrixStack, x + width, y + i, 16, 206, 2, drawHeight);
        }
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_230457_a_(MatrixStack matrixStack, ItemStack itemStack, int x, int y) {
        super.func_230457_a_(matrixStack, itemStack, x, y);
    }

    public int getTick() {
        return (int)this.getMinecraft().field_71441_e.func_82737_E();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.field_230706_i_.field_71439_g.func_70089_S()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public abstract void playPageFlipSound(SoundHandler var1);

    public abstract void playPagesFlipSound(SoundHandler var1);

    @OnlyIn(value=Dist.CLIENT)
    static class TextOverlayButton
    extends Button {
        private final ScreenInfoBook guiInfoBook;
        private HyperLink link;

        public TextOverlayButton(HyperLink link, int x, int y, int height, int maxWidth, Button.IPressable onPress, ScreenInfoBook guiInfoBook) {
            super(x, y, 0, height, (ITextComponent)new StringTextComponent(InfoSection.formatString(L10NHelpers.localize(link.getTranslationKey(), new Object[0]))), onPress);
            this.guiInfoBook = guiInfoBook;
            this.link = link;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.field_230688_j_ = fontRenderer.func_243245_a(this.func_230458_i_().func_241878_f());
            if (this.field_230688_j_ > maxWidth) {
                String originalMessage = this.func_230458_i_().getString();
                originalMessage = originalMessage.substring(0, (int)((float)maxWidth / (float)this.field_230688_j_ * (float)originalMessage.length()) - 1);
                originalMessage = originalMessage + "\u2026";
                this.func_238482_a_((ITextComponent)new StringTextComponent(originalMessage));
                this.field_230688_j_ = maxWidth;
            }
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean isHover = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                Minecraft minecraft = Minecraft.func_71410_x();
                IFormattableTextComponent msg = (IFormattableTextComponent)this.func_230458_i_();
                if (isHover) {
                    msg = msg.func_240699_a_(TextFormatting.UNDERLINE);
                }
                minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)msg, (float)this.field_230690_l_, (float)this.field_230691_m_, Helpers.RGBToInt(isHover ? 100 : 0, isHover ? 100 : 0, isHover ? 150 : 125));
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            this.guiInfoBook.playPagesFlipSound(soundHandler);
        }

        public HyperLink getLink() {
            return this.link;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class NextPageButton
    extends Button {
        private final ScreenInfoBook guiInfoBook;
        private int textureX;
        private int textureY;

        public NextPageButton(int x, int y, int textureX, int textureY, int width, int height, Button.IPressable onPress, ScreenInfoBook guiInfoBook) {
            super(x, y, width, height, (ITextComponent)new StringTextComponent(""), onPress);
            this.textureX = textureX;
            this.textureY = textureY;
            this.guiInfoBook = guiInfoBook;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean isHover = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelpers.bindTexture(this.guiInfoBook.texture);
                int k = this.textureX;
                int l = this.textureY;
                if (isHover) {
                    k += this.field_230688_j_;
                }
                GlStateManager.func_227740_m_();
                GlStateManager.func_227676_b_((int)770, (int)771);
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, k, l, this.field_230688_j_, this.field_230689_k_);
                GlStateManager.func_227737_l_();
            }
        }

        public void func_230988_a_(SoundHandler soundHandler) {
            this.guiInfoBook.playPageFlipSound(soundHandler);
        }
    }
}

