/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;

@OnlyIn(value=Dist.CLIENT)
public class AchievementCollectButton
extends AdvancedButton {
    private final AdvancementRewards advancementRewards;
    private final IInfoBook infoBook;

    public AchievementCollectButton(AdvancementRewards advancementRewards, IInfoBook infoBook) {
        this.advancementRewards = advancementRewards;
        this.infoBook = infoBook;
    }

    protected IInfoBook getInfoBook() {
        return this.infoBook;
    }

    @Override
    public void renderTooltip(MatrixStack matrixStack, int mx, int my) {
        super.renderTooltip(matrixStack, mx, my);
        GlStateManager.func_227626_N_();
        if (mx >= this.field_230690_l_ && my >= this.field_230691_m_ && mx <= this.field_230690_l_ + this.field_230688_j_ && my <= this.field_230691_m_ + this.field_230689_k_) {
            ArrayList lines = Lists.newArrayList();
            if (this.advancementRewards.isObtained((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
                lines.add(IReorderingProcessor.func_242239_a((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collected", new Object[0]), (Style)Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true))));
            } else {
                lines.add(IReorderingProcessor.func_242239_a((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collect", new Object[0]), (Style)Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true))));
                boolean canObtain = true;
                for (IReward reward : this.advancementRewards.getRewards()) {
                    if (reward.canObtain((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) continue;
                    canObtain = false;
                }
                if (!canObtain) {
                    lines.add(IReorderingProcessor.func_242239_a((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collectFailure", new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))));
                }
            }
            this.gui.func_238654_b_(matrixStack, lines, mx, my);
        }
        GlStateManager.func_227627_O_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
    }

    @Override
    public boolean isVisible() {
        return this.field_230694_p_;
    }

    @Override
    public void func_230930_b_() {
        super.func_230930_b_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean canObtain = true;
        for (ResourceLocation advancement : this.advancementRewards.getAdvancements()) {
            if (AdvancementHelpers.hasAdvancementUnlocked((PlayerEntity)Minecraft.func_71410_x().field_71439_g, advancement)) continue;
            canObtain = false;
        }
        for (IReward reward : this.advancementRewards.getRewards()) {
            if (reward.canObtain((PlayerEntity)player)) continue;
            canObtain = false;
        }
        if (canObtain) {
            this.advancementRewards.obtain((PlayerEntity)player);
        }
    }

    @Override
    public void update(int x, int y, ITextComponent displayName, InfoSection target, ScreenInfoBook gui) {
        super.update(x, y, displayName, target, gui);
        this.field_230688_j_ = 80;
    }
}

