/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class NBTSimpleInventoryItemHeld
extends SimpleInventory {
    protected final PlayerEntity player;
    protected final int itemIndex;
    protected final Hand hand;
    protected final String tagName;

    public NBTSimpleInventoryItemHeld(PlayerEntity player, int itemIndex, int size, int stackLimit, String tagName) {
        this(player, itemIndex, Hand.MAIN_HAND, size, stackLimit, tagName);
    }

    public NBTSimpleInventoryItemHeld(PlayerEntity player, int itemIndex, Hand hand, int size, int stackLimit, String tagName) {
        super(size, stackLimit);
        this.player = player;
        this.itemIndex = itemIndex;
        this.hand = hand;
        this.tagName = tagName;
        InventoryHelpers.validateNBTStorage(this, InventoryHelpers.getItemFromIndex(player, itemIndex, hand), this.tagName);
    }

    @Override
    public void func_70296_d() {
        ItemStack itemStack = InventoryHelpers.getItemFromIndex(this.player, this.itemIndex, this.hand);
        CompoundNBT tag = itemStack.func_196082_o();
        this.writeToNBT(tag, this.tagName);
        InventoryHelpers.getItemFromIndex(this.player, this.itemIndex, this.hand).func_77982_d(tag);
    }

    @Override
    public void readFromNBT(CompoundNBT data, String tagName) {
        InventoryHelpers.readFromNBT(this, data, tagName);
    }

    @Override
    public void writeToNBT(CompoundNBT data, String tagName) {
        InventoryHelpers.writeToNBT(this, data, tagName);
    }
}

