/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtParseException;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public class NbtPathExpressionList
implements INbtPathExpression {
    private final INbtPathExpression[] subExpressions;

    public NbtPathExpressionList(INbtPathExpression ... subExpressions) {
        this.subExpressions = subExpressions;
    }

    @Override
    public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
        NbtPathExpressionMatches matches = new NbtPathExpressionMatches(executionContexts);
        for (INbtPathExpression subExpression : this.subExpressions) {
            matches = subExpression.matchContexts(matches.getContexts());
        }
        return matches;
    }

    public INbtPathExpression[] getSubExpressions() {
        return this.subExpressions;
    }

    @Override
    public INbtPathNavigation asNavigation(@Nullable INbtPathNavigation child) throws NbtParseException {
        INbtPathNavigation current = null;
        for (int i = this.subExpressions.length - 1; i >= 0; --i) {
            current = current != null ? this.subExpressions[i].asNavigation(current) : this.subExpressions[i].asNavigation(null);
        }
        return current;
    }
}

