/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.recipe.type.RecipeCraftingShapelessCustomOutput;

public class RecipeSerializerCraftingShapelessCustomOutput
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RecipeCraftingShapelessCustomOutput> {
    private final Supplier<ItemStack> outputProvider;
    @Nullable
    private final IOutputTransformer outputTransformer;

    public RecipeSerializerCraftingShapelessCustomOutput(Supplier<ItemStack> outputProvider, @Nullable IOutputTransformer outputTransformer) {
        this.outputProvider = outputProvider;
        this.outputTransformer = outputTransformer;
    }

    public RecipeSerializerCraftingShapelessCustomOutput(Supplier<ItemStack> outputProvider) {
        this(outputProvider, null);
    }

    @Nullable
    public IOutputTransformer getOutputTransformer() {
        return this.outputTransformer;
    }

    public RecipeCraftingShapelessCustomOutput read(ResourceLocation recipeId, JsonObject json) {
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> nonnulllist = RecipeSerializerCraftingShapelessCustomOutput.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        ItemStack itemstack = this.outputProvider.get();
        return new RecipeCraftingShapelessCustomOutput(this, recipeId, s, itemstack, nonnulllist);
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public RecipeCraftingShapelessCustomOutput read(ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        int i = buffer.func_150792_a();
        NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
        for (int j = 0; j < nonnulllist.size(); ++j) {
            nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack itemstack = buffer.func_150791_c();
        return new RecipeCraftingShapelessCustomOutput(this, recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
    }

    public void write(PacketBuffer buffer, RecipeCraftingShapelessCustomOutput recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        buffer.func_150787_b(recipe.func_192400_c().size());
        for (Ingredient ingredient : recipe.func_192400_c()) {
            ingredient.func_199564_a(buffer);
        }
        buffer.func_150788_a(recipe.func_77571_b());
    }

    public static interface IOutputTransformer {
        public ItemStack transform(CraftingInventory var1, ItemStack var2);
    }
}

