/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Locale;
import javax.annotation.Nullable;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.type.ShelfType;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.datagen.InspirationsBlockTagsProvider;
import knightminer.inspirations.common.datagen.InspirationsFluidTagsProvider;
import knightminer.inspirations.common.datagen.InspirationsItemTagsProvider;
import knightminer.inspirations.common.datagen.InspirationsLootTableProvider;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.shared.SharedClientEvents;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;

@Mod(value="inspirations")
public class Inspirations {
    public static final String modID = "inspirations";
    public static final Logger log = LogManager.getLogger((String)"inspirations");

    public Inspirations() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        log.info("Loading replacements config file...");
        CommentedFileConfig replacementConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("inspirations-replacements.toml")).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        replacementConfig.load();
        replacementConfig.save();
        Config.OVERRIDE_SPEC.setConfig((CommentedConfig)replacementConfig);
        log.info("Config loaded.");
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.register((Object)this);
        modBus.register((Object)new InspirationsShared());
        modBus.register((Object)new InspirationsBuilding());
        modBus.register((Object)new InspirationsUtility());
        modBus.register((Object)new InspirationsTools());
        modBus.register((Object)new InspirationsTweaks());
        modBus.register((Object)new InspirationsRecipes());
        modBus.addListener(Config::configChanged);
        MinecraftForge.EVENT_BUS.register(Inspirations.class);
        InspirationsNetwork.INSTANCE.setup();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SharedClientEvents::onConstruct);
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            ExistingFileHelper existing = event.getExistingFileHelper();
            InspirationsBlockTagsProvider blockTags = new InspirationsBlockTagsProvider(gen, existing);
            gen.func_200390_a((IDataProvider)blockTags);
            gen.func_200390_a((IDataProvider)new InspirationsItemTagsProvider(gen, existing, blockTags));
            gen.func_200390_a((IDataProvider)new InspirationsFluidTagsProvider(gen, existing));
            gen.func_200390_a((IDataProvider)new InspirationsLootTableProvider(gen));
        }
    }

    @Nullable
    private static Block missingBlock(String name) {
        switch (name) {
            case "bookshelf": {
                return (Block)InspirationsBuilding.shelf.get((Enum)ShelfType.NORMAL);
            }
            case "ancient_bookshelf": {
                return (Block)InspirationsBuilding.shelf.get((Enum)ShelfType.ANCIENT);
            }
            case "rainbow_bookshelf": {
                return (Block)InspirationsBuilding.shelf.get((Enum)ShelfType.RAINBOW);
            }
            case "tomes_bookshelf": {
                return (Block)InspirationsBuilding.shelf.get((Enum)ShelfType.TOMES);
            }
        }
        return null;
    }

    @SubscribeEvent
    static void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        RegistrationHelper.handleMissingMappings(event, (String)modID, Inspirations::missingBlock);
    }

    @SubscribeEvent
    static void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        RegistrationHelper.handleMissingMappings(event, (String)modID, name -> {
            switch (name) {
                case "white_waypoint_compass": 
                case "orange_waypoint_compass": 
                case "magenta_waypoint_compass": 
                case "light_blue_waypoint_compass": 
                case "yellow_waypoint_compass": 
                case "lime_waypoint_compass": 
                case "pink_waypoint_compass": 
                case "gray_waypoint_compass": 
                case "light_gray_waypoint_compass": 
                case "cyan_waypoint_compass": 
                case "purple_waypoint_compass": 
                case "blue_waypoint_compass": 
                case "brown_waypoint_compass": 
                case "green_waypoint_compass": 
                case "red_waypoint_compass": 
                case "black_waypoint_compass": {
                    return InspirationsTools.dimensionCompass;
                }
            }
            Block block = Inspirations.missingBlock(name);
            return block != null ? block.func_199767_j() : null;
        });
    }

    @SubscribeEvent
    static void missingFluidMappings(RegistryEvent.MissingMappings<Fluid> event) {
        RegistrationHelper.handleMissingMappings(event, (String)modID, name -> {
            switch (name) {
                case "milk": {
                    return (Fluid)ForgeMod.MILK.get();
                }
                case "flowing_milk": {
                    return (Fluid)ForgeMod.FLOWING_MILK.get();
                }
            }
            return null;
        });
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(modID, name);
    }

    public static String resourceName(String name) {
        return String.format("%s:%s", modID, name.toLowerCase(Locale.US));
    }

    public static String prefix(String name) {
        return String.format("%s.%s", modID, name.toLowerCase(Locale.US));
    }
}

