/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import java.util.Optional;
import java.util.function.Consumer;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.type.BushType;
import knightminer.inspirations.building.block.type.ShelfType;
import knightminer.inspirations.building.client.ShelfScreen;
import knightminer.inspirations.building.client.ShelfTileEntityRenderer;
import knightminer.inspirations.building.tileentity.ShelfTileEntity;
import knightminer.inspirations.common.ClientEvents;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.client.model.ShelfModel;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.tileentity.IRetexturedTileEntity;
import slimeknights.mantle.util.TileEntityHelper;

@Mod.EventBusSubscriber(modid="inspirations", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BuildingClientEvents
extends ClientEvents {
    private static final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.func_228643_e_();
        Consumer<Block> setCutout = block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)cutout);
        RenderType cutoutMipped = RenderType.func_228641_d_();
        Consumer<Block> setCutoutMipped = block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)cutoutMipped);
        InspirationsBuilding.shelf.forEach(setCutout);
        InspirationsBuilding.enlightenedBush.forEach(setCutoutMipped);
        ClientRegistry.bindTileEntityRenderer(InspirationsBuilding.shelfTileEntity, ShelfTileEntityRenderer::new);
        BuildingClientEvents.setRenderLayer(InspirationsBuilding.rope, cutout);
        BuildingClientEvents.setRenderLayer(InspirationsBuilding.vine, cutout);
        BuildingClientEvents.setRenderLayer(InspirationsBuilding.ironBars, cutoutMipped);
        BuildingClientEvents.setRenderLayer(InspirationsBuilding.glassDoor, cutoutMipped);
        BuildingClientEvents.setRenderLayer(InspirationsBuilding.glassTrapdoor, cutoutMipped);
        InspirationsBuilding.flower.forEach(setCutout);
        InspirationsBuilding.flowerPot.forEach(setCutout);
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)Inspirations.getResource("shelf"), (IModelLoader)ShelfModel.LOADER);
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        BuildingClientEvents.registerScreenFactory(InspirationsBuilding.shelfContainer, ShelfScreen::new);
    }

    @SubscribeEvent
    static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        BuildingClientEvents.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            ItemStack stack;
            TileEntity te;
            if (tintIndex > 0 && tintIndex <= 16 && world != null && pos != null && (te = world.func_175625_s(pos)) instanceof ShelfTileEntity && !(stack = ((ShelfTileEntity)te).getInventory().getStackInSlot(tintIndex - 1)).func_190926_b()) {
                int color = ClientUtil.getItemColor(stack.func_77973_b());
                int itemColors = mc.getItemColors().func_186728_a(stack, 0);
                if (itemColors > -1) {
                    color = Util.combineColors(color, itemColors, 3);
                }
                return color;
            }
            return -1;
        }, (Block)InspirationsBuilding.shelf.getOrNull((Enum)ShelfType.NORMAL));
        BuildingClientEvents.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            if (world != null && pos != null) {
                return BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos);
            }
            return FoliageColors.func_77468_c();
        }, InspirationsBuilding.vine);
        InspirationsBuilding.enlightenedBush.forEach((type, bush) -> {
            if (type != BushType.WHITE) {
                int color = type.getColor();
                blockColors.func_186722_a((state, world, pos, tintIndex) -> tintIndex == 0 ? color : -1, new Block[]{bush});
            }
        });
        BuildingClientEvents.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            Block block;
            if (tintIndex != 0 || world == null || pos == null) {
                return -1;
            }
            Optional te = TileEntityHelper.getTile(IRetexturedTileEntity.class, (IBlockReader)world, (BlockPos)pos);
            if (te.isPresent() && (block = ((IRetexturedTileEntity)te.get()).getTexture()) != Blocks.field_150350_a) {
                return ClientUtil.getStackBlockColorsSafe(new ItemStack((IItemProvider)block), world, pos, 0);
            }
            return FoliageColors.func_77468_c();
        }, (Block)InspirationsBuilding.enlightenedBush.getOrNull((Enum)BushType.WHITE));
    }

    @SubscribeEvent
    static void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        BuildingClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex > 0 && tintIndex <= 16) {
                return 6638359;
            }
            return -1;
        }, (IItemProvider)InspirationsBuilding.shelf.getOrNull((Enum)ShelfType.NORMAL));
        InspirationsBuilding.coloredBooks.forEach((color, book) -> {
            int hexColor = color.getColorValue();
            itemColors.func_199877_a((stack, tintIndex) -> tintIndex == 0 ? hexColor : -1, new IItemProvider[]{book});
        });
        InspirationsBuilding.enlightenedBush.forEach((type, bush) -> {
            if (type != BushType.WHITE) {
                int color = type.getColor();
                itemColors.func_199877_a((stack, tintIndex) -> tintIndex == 0 ? color : -1, new IItemProvider[]{bush});
            }
        });
        BuildingClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            Block block = RetexturedBlockItem.getTexture((ItemStack)stack);
            if (block != Blocks.field_150350_a) {
                return itemColors.func_186728_a(new ItemStack((IItemProvider)block), 0);
            }
            return FoliageColors.func_77468_c();
        }, (IItemProvider)InspirationsBuilding.enlightenedBush.getOrNull((Enum)BushType.WHITE));
        BuildingClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> FoliageColors.func_77468_c(), new IItemProvider[]{InspirationsBuilding.vine});
    }
}

