/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import java.util.Objects;
import java.util.function.Supplier;
import knightminer.inspirations.building.block.ClimbablePaneBlock;
import knightminer.inspirations.building.block.EnlightenedBushBlock;
import knightminer.inspirations.building.block.FlowerBlock;
import knightminer.inspirations.building.block.GlassDoorBlock;
import knightminer.inspirations.building.block.GlassTrapdoorBlock;
import knightminer.inspirations.building.block.MulchBlock;
import knightminer.inspirations.building.block.PathBlock;
import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.building.block.ShelfBlock;
import knightminer.inspirations.building.block.type.BushType;
import knightminer.inspirations.building.block.type.FlowerType;
import knightminer.inspirations.building.block.type.MulchType;
import knightminer.inspirations.building.block.type.PathType;
import knightminer.inspirations.building.block.type.ShelfType;
import knightminer.inspirations.building.datagen.BuildingRecipeProvider;
import knightminer.inspirations.building.inventory.ShelfContainer;
import knightminer.inspirations.building.item.GlassDoorBlockItem;
import knightminer.inspirations.building.item.ShelfItem;
import knightminer.inspirations.building.tileentity.EnlightenedBushTileEntity;
import knightminer.inspirations.building.tileentity.ShelfTileEntity;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.common.item.HidableBlockItem;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.common.item.HidableRetexturedBlockItem;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.ContainerTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.adapter.TileEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsBuilding
extends ModuleBase {
    public static RopeBlock rope;
    public static RopeBlock vine;
    public static Block glassDoor;
    public static Block glassTrapdoor;
    public static EnumObject<ShelfType, ShelfBlock> shelf;
    public static EnumObject<MulchType, MulchBlock> mulch;
    public static EnumObject<PathType, PathBlock> path;
    public static EnumObject<BushType, EnlightenedBushBlock> enlightenedBush;
    public static EnumObject<FlowerType, FlowerBlock> flower;
    public static EnumObject<FlowerType, FlowerPotBlock> flowerPot;
    public static Block ironBars;
    public static Item glassDoorItem;
    public static Item redstoneBook;
    public static EnumObject<DyeColor, Item> coloredBooks;
    public static TileEntityType<ShelfTileEntity> shelfTileEntity;
    public static TileEntityType<EnlightenedBushTileEntity> enlightenedBushTileEntity;
    public static ContainerType<ShelfContainer> shelfContainer;

    @SubscribeEvent
    void registerTE(RegistryEvent.Register<TileEntityType<?>> event) {
        TileEntityTypeRegistryAdapter registry = new TileEntityTypeRegistryAdapter(event.getRegistry());
        shelfTileEntity = registry.register(ShelfTileEntity::new, shelf, "bookshelf");
        enlightenedBushTileEntity = registry.register(EnlightenedBushTileEntity::new, enlightenedBush, "enlightened_bush");
    }

    @SubscribeEvent
    void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        ContainerTypeRegistryAdapter registry = new ContainerTypeRegistryAdapter(event.getRegistry());
        shelfContainer = registry.registerType(ShelfContainer::new, "shelf");
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistryAdapter registry = new BlockRegistryAdapter(event.getRegistry());
        AbstractBlock.Properties shelfProps = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.AXE).func_200948_a(2.0f, 5.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_();
        shelf = new EnumObject.Builder(ShelfType.class).putDelegate((Enum)ShelfType.NORMAL, ((ShelfBlock)registry.register((IForgeRegistryEntry)new ShelfBlock((AbstractBlock.Properties)shelfProps), (String)"shelf")).delegate).putAll(registry.registerEnum(type -> new ShelfBlock(shelfProps), (Enum[])ShelfType.FANCY, "shelf")).build();
        rope = (RopeBlock)registry.register((IForgeRegistryEntry)new RopeBlock(Items.field_151055_y, AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151654_J).func_200947_a(SoundType.field_185854_g).func_200943_b(0.5f)), "rope");
        vine = (RopeBlock)registry.register((IForgeRegistryEntry)new RopeBlock(Items.field_222068_kQ, AbstractBlock.Properties.func_200949_a((Material)Material.field_151593_r, (MaterialColor)MaterialColor.field_151669_i).func_200947_a(SoundType.field_185850_c).func_200943_b(0.5f)), "vine");
        if (((Boolean)Config.climbableIronBars.get()).booleanValue()) {
            ironBars = (Block)registry.register((IForgeRegistryEntry)new ClimbablePaneBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151660_b).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e)), new ResourceLocation("iron_bars"));
        }
        AbstractBlock.Properties glassDoorProps = AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_();
        glassDoor = (Block)registry.register((IForgeRegistryEntry)new GlassDoorBlock(glassDoorProps), "glass_door");
        glassTrapdoor = (Block)registry.register((IForgeRegistryEntry)new GlassTrapdoorBlock(glassDoorProps), "glass_trapdoor");
        mulch = registry.registerEnum(type -> new MulchBlock(type.getColor()), (Enum[])MulchType.values(), "mulch");
        path = registry.registerEnum(type -> new PathBlock(type.getShape(), type.getColor()), (Enum[])PathType.values(), "path");
        enlightenedBush = registry.registerEnum(type -> new EnlightenedBushBlock(type.getColor()), (Enum[])BushType.values(), "enlightened_bush");
        flower = new EnumObject.Builder(FlowerType.class).putDelegate((Enum)FlowerType.CYAN, ((FlowerBlock)registry.register((IForgeRegistryEntry)new FlowerBlock(null), (String)"cyan_flower")).delegate).putDelegate((Enum)FlowerType.SYRINGA, ((FlowerBlock)registry.register((IForgeRegistryEntry)new FlowerBlock((DoublePlantBlock)((DoublePlantBlock)Blocks.field_196801_ge)), (String)"syringa")).delegate).putDelegate((Enum)FlowerType.PAEONIA, ((FlowerBlock)registry.register((IForgeRegistryEntry)new FlowerBlock((DoublePlantBlock)((DoublePlantBlock)Blocks.field_196803_gg)), (String)"paeonia")).delegate).putDelegate((Enum)FlowerType.ROSE, ((FlowerBlock)registry.register((IForgeRegistryEntry)new FlowerBlock((DoublePlantBlock)((DoublePlantBlock)Blocks.field_196802_gf)), (String)"rose")).delegate).build();
        Supplier<FlowerPotBlock> emptyPot = () -> (FlowerPotBlock)Blocks.field_150457_bL.delegate.get();
        FlowerPotBlock vanillaPot = (FlowerPotBlock)Blocks.field_150457_bL;
        AbstractBlock.Properties props = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150457_bL);
        flowerPot = registry.registerEnum(type -> {
            Block plant = (Block)flower.get((Enum)type);
            FlowerPotBlock pot = new FlowerPotBlock(emptyPot, (Supplier)plant.delegate, props);
            vanillaPot.addPlant(Objects.requireNonNull(plant.getRegistryName()), (Supplier)pot.delegate);
            return pot;
        }, "potted", (Enum[])FlowerType.values());
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemRegistryAdapter registry = new ItemRegistryAdapter(event.getRegistry());
        Item.Properties materialProps = new Item.Properties().func_200916_a(ItemGroup.field_78035_l);
        Item.Properties decorationProps = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
        Item.Properties buildingProps = new Item.Properties().func_200916_a(ItemGroup.field_78030_b);
        Item.Properties redstoneProps = new Item.Properties().func_200916_a(ItemGroup.field_78028_d);
        coloredBooks = registry.registerEnum(color -> new HidableItem(materialProps, (Supplier<Boolean>)Config.enableColoredBooks), (Enum[])DyeColor.values(), "book");
        redstoneBook = (Item)registry.register((IForgeRegistryEntry)new HidableItem(materialProps, (Supplier<Boolean>)Config.enableRedstoneBook), "redstone_book");
        registry.registerBlockItem(shelf, ShelfItem::new);
        registry.registerBlockItem((Block)rope, decorationProps);
        registry.registerBlockItem((Block)vine, decorationProps);
        if (ironBars != null) {
            registry.registerBlockItem(ironBars, decorationProps);
        }
        registry.registerBlockItem(mulch, buildingProps);
        registry.registerBlockItem(path, decorationProps);
        registry.registerBlockItem(flower, decorationProps);
        registry.registerBlockItem(enlightenedBush, bush -> new HidableRetexturedBlockItem((Block)bush, (ITag<Item>)ItemTags.field_206963_E, decorationProps));
        glassDoorItem = (Item)registry.register((IForgeRegistryEntry)new GlassDoorBlockItem(glassDoor, redstoneProps), (IForgeRegistryEntry)glassDoor);
        registry.registerBlockItem((BlockItem)new HidableBlockItem(glassTrapdoor, redstoneProps));
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new BuildingRecipeProvider(gen));
        }
    }

    @SubscribeEvent
    void init(FMLCommonSetupEvent event) {
        event.enqueueWork(InspirationsBuilding::registerCompostables);
    }

    @SubscribeEvent
    public static void loadLoad(LootTableLoadEvent event) {
        flower.forEach((type, plant) -> {
            if (type != FlowerType.CYAN) {
                plant.injectLoot(event);
            }
        });
    }

    private static void registerCompostables() {
        for (Block bush : enlightenedBush.values()) {
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)bush);
        }
        ComposterBlock.func_220290_a((float)0.5f, (IItemProvider)vine);
        for (Block plant : flower.values()) {
            ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)plant);
        }
    }

    static {
        shelf = EnumObject.empty();
        mulch = EnumObject.empty();
        path = EnumObject.empty();
        enlightenedBush = EnumObject.empty();
        flower = EnumObject.empty();
        flowerPot = EnumObject.empty();
    }
}

