/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.LootTableLoadEvent;

public class FlowerBlock
extends BushBlock
implements IGrowable,
IHidable {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private final DoublePlantBlock largePlant;

    public FlowerBlock(@Nullable DoublePlantBlock largePlant) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
        this.largePlant = largePlant;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableFlowers.get();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.func_149666_a(group, items);
        }
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Vector3d off = state.func_191059_e(world, pos);
        return SHAPE.func_197751_a(off.field_72450_a, off.field_72448_b, off.field_72449_c);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.largePlant != null;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if (this.largePlant == null) {
            return;
        }
        if (world.func_175623_d(pos.func_177984_a())) {
            this.largePlant.func_196390_a((IWorld)world, pos, 2);
        }
    }

    public void injectLoot(LootTableLoadEvent event) {
        if (this.largePlant == null || !event.getName().func_110624_b().equals("minecraft") || !event.getName().func_110623_a().equals("blocks/" + Objects.requireNonNull(this.largePlant.getRegistryName()).func_110623_a())) {
            return;
        }
        LootTable table = event.getTable();
        if (table.removePool("main") == null) {
            return;
        }
        ResourceLocation location = Inspirations.getResource("blocks/inject/" + Objects.requireNonNull(this.getRegistryName()).func_110623_a());
        table.addPool(new LootPool.Builder().name(location.toString()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)location)).func_216044_b());
    }
}

