/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.block.HidableBlock;
import knightminer.inspirations.library.InspirationsTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import slimeknights.mantle.config.CachedBoolean;

public class PathBlock
extends HidableBlock
implements IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final VoxelShape shape;
    private final VoxelShape collShape;

    public PathBlock(VoxelShape shape, MaterialColor mapColor) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)mapColor).func_200948_a(1.5f, 10.0f).harvestTool(ToolType.PICKAXE).harvestLevel(0), () -> ((CachedBoolean)Config.enablePath).get());
        this.shape = shape;
        this.collShape = VoxelShapes.func_197881_a((AxisAlignedBB)shape.func_197752_a());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.collShape;
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return super.func_196260_a(state, world, pos) && this.canBlockStay(world, pos);
    }

    private boolean canBlockStay(IWorldReader world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        return Block.func_220064_c((IBlockReader)world, (BlockPos)down) || world.func_180495_p(down).func_235714_a_(InspirationsTags.Blocks.MULCH);
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block other, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay((IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        } else if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
    }
}

