/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.inventory.ShelfContainer;
import knightminer.inspirations.building.tileentity.ShelfInventory;
import knightminer.inspirations.building.tileentity.ShelfTileEntity;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.shared.client.BackgroundContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.client.screen.ElementScreen;

public class ShelfScreen
extends BackgroundContainerScreen<ShelfContainer> {
    private static final ElementScreen SLOT_COVER = new ElementScreen(176, 0, 18, 18, 256, 256);
    private static final ElementScreen BOOK_SLOT_ICON = new ElementScreen(176, 18, 16, 16, 256, 256);

    public ShelfScreen(ShelfContainer container, PlayerInventory inventory, ITextComponent name) {
        super(container, inventory, name, 156, Inspirations.getResource("textures/gui/shelf.png"));
    }

    private void checkBookIcon(MatrixStack matrixStack, ShelfInventory inventory, int index) {
        if (inventory.getStackInSlot(index).func_190926_b() && (index % 8 == 7 || !inventory.getStackInSlot(index + 1).func_190926_b())) {
            Slot slot = ((ShelfContainer)this.func_212873_a_()).func_75139_a(index);
            BOOK_SLOT_ICON.draw(matrixStack, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        ShelfTileEntity shelf = (ShelfTileEntity)((ShelfContainer)this.func_212873_a_()).getTile();
        if (shelf != null) {
            ShelfInventory inventory = shelf.getInventory();
            for (int i = 0; i < 16; ++i) {
                this.checkBookIcon(matrixStack, inventory, i);
            }
        }
    }

    private void checkCoverSlot(MatrixStack matrixStack, ShelfInventory inventory, int index) {
        ItemStack previous;
        if (inventory.getStackInSlot(index).func_190926_b() && !(previous = inventory.getStackInSlot(index - 1)).func_190926_b() && !InspirationsRegistry.isBook(previous)) {
            Slot slot = ((ShelfContainer)this.func_212873_a_()).func_75139_a(index);
            SLOT_COVER.draw(matrixStack, slot.field_75223_e - 1, slot.field_75221_f - 1);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        ShelfTileEntity shelf = (ShelfTileEntity)((ShelfContainer)this.func_212873_a_()).getTile();
        if (shelf != null) {
            int i;
            ShelfInventory inventory = shelf.getInventory();
            assert (this.field_230706_i_ != null);
            this.field_230706_i_.func_110434_K().func_110577_a(this.background);
            for (i = 1; i < 8; ++i) {
                this.checkCoverSlot(matrixStack, inventory, i);
            }
            for (i = 9; i < 16; ++i) {
                this.checkCoverSlot(matrixStack, inventory, i);
            }
        }
    }
}

