/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronTransform;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.TileEntityHelper;

public class CauldronTransformUpatePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    @Nullable
    private final ResourceLocation recipe;

    public CauldronTransformUpatePacket(BlockPos pos, @Nullable ICauldronTransform recipe) {
        this.pos = pos;
        this.recipe = recipe == null ? null : recipe.func_199560_c();
    }

    public CauldronTransformUpatePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.recipe = buffer.readBoolean() ? buffer.func_192575_l() : null;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        if (this.recipe == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_192572_a(this.recipe);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(CauldronTransformUpatePacket packet) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                ICauldronTransform recipe = packet.recipe == null ? null : (ICauldronTransform)RecipeHelper.getRecipe((RecipeManager)world.func_199532_z(), (ResourceLocation)packet.recipe, ICauldronTransform.class).orElse(null);
                TileEntityHelper.getTile(CauldronTileEntity.class, (IBlockReader)world, (BlockPos)packet.pos, (boolean)true).ifPresent(te -> te.setTransformRecipe(recipe));
            }
        }
    }
}

