/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class MilkablePacket
implements IThreadsafePacket {
    private final int entityID;
    private final boolean milkable;

    public MilkablePacket(Entity entity, boolean milkable) {
        this.entityID = entity.func_145782_y();
        this.milkable = milkable;
    }

    public MilkablePacket(PacketBuffer buf) {
        this.entityID = buf.readInt();
        this.milkable = buf.readBoolean();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.milkable);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(MilkablePacket packet) {
            assert (Minecraft.func_71410_x().field_71441_e != null);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(packet.entityID);
            if (entity == null) {
                return;
            }
            entity.getPersistentData().func_74777_a("milk_cooldown", (short)(packet.milkable ? 0 : 100));
        }
    }
}

