/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsTags;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ToolType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InspirationsRegistry {
    public static final Logger log = LogManager.getLogger((String)"inspirations-api");
    public static final ToolType SHEAR_TYPE = ToolType.get((String)"shears");
    private static final Map<Item, Float> bookCache = new HashMap<Item, Float>();
    private static List<String> bookKeywords = new ArrayList<String>();

    public static boolean isBook(ItemStack stack) {
        return !stack.func_190926_b() && InspirationsRegistry.getBookEnchantingPower(stack) >= 0.0f;
    }

    public static float getBookEnchantingPower(ItemStack book) {
        if (book.func_190926_b()) {
            return 0.0f;
        }
        return bookCache.computeIfAbsent(book.func_77973_b(), InspirationsRegistry::bookPower).floatValue();
    }

    private static Float bookPower(Item item) {
        if (item.func_206844_a(InspirationsTags.Items.BOOKS)) {
            return Float.valueOf(((Double)Config.defaultEnchantingPower.get()).floatValue());
        }
        if (Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            return Float.valueOf(-1.0f);
        }
        for (String keyword : bookKeywords) {
            if (!Objects.requireNonNull(item.getRegistryName()).func_110623_a().contains(keyword) && !item.func_77658_a().contains(keyword)) continue;
            return Float.valueOf(((Double)Config.defaultEnchantingPower.get()).floatValue());
        }
        return Float.valueOf(-1.0f);
    }

    public static void setBookKeywords(List<String> keywords) {
        bookKeywords = keywords;
        bookCache.clear();
    }
}

