/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import slimeknights.mantle.client.IEarlySelectiveReloadListener;

public class CustomTextureLoader
implements IEarlySelectiveReloadListener {
    private final Map<ResourceLocation, ResourceLocation> textures = new HashMap<ResourceLocation, ResourceLocation>();
    private final ResourceLocation file;

    public CustomTextureLoader(ResourceLocation file) {
        this.file = new ResourceLocation(file.func_110624_b(), "models/" + file.func_110623_a() + ".json");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTextureStitch);
    }

    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> type) {
        if (type.test((IResourceType)VanillaResourceType.MODELS)) {
            List<Object> jsonFiles;
            try {
                jsonFiles = manager.func_199004_b(this.file).stream().map(CustomTextureLoader::getJson).filter(Objects::nonNull).collect(Collectors.toList());
            }
            catch (IOException e) {
                jsonFiles = Collections.emptyList();
                Inspirations.log.error("Failed to load model settings file", (Throwable)e);
            }
            for (JsonObject json : jsonFiles) {
                for (Map.Entry entry : json.entrySet()) {
                    String key = (String)entry.getKey();
                    ResourceLocation name = ResourceLocation.func_208304_a((String)key);
                    if (name == null) {
                        Inspirations.log.error("Skipping invalid key " + key + " as it is not a valid resource location");
                        continue;
                    }
                    if (!ModList.get().isLoaded(name.func_110624_b())) {
                        Inspirations.log.debug("Skipping loading texture " + key + " as the dependent mod is not loaded");
                        continue;
                    }
                    JsonElement element = (JsonElement)entry.getValue();
                    if (!element.isJsonPrimitive()) {
                        Inspirations.log.error("Skipping key " + key + " as the value is not a string");
                        continue;
                    }
                    ResourceLocation texture = ResourceLocation.func_208304_a((String)element.getAsString());
                    if (texture == null) {
                        Inspirations.log.error("Skipping key " + key + " as the texture " + element.getAsString() + " is an invalid texture path");
                        continue;
                    }
                    this.textures.put(name, texture);
                }
            }
        }
    }

    private void onTextureStitch(TextureStitchEvent.Pre event) {
        if (PlayerContainer.field_226615_c_.equals((Object)event.getMap().func_229223_g_())) {
            this.textures.values().forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonObject getJson(IResource resource) {
        try {
            Throwable thrown = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
            try {
                JsonObject jsonObject = JSONUtils.func_212743_a((Reader)reader);
                return jsonObject;
            }
            catch (Throwable e) {
                thrown = e;
                throw e;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    if (thrown == null) throw e;
                    thrown.addSuppressed(e);
                }
            }
        }
        catch (JsonParseException | IOException e3) {
            Inspirations.log.error("Failed to load texture JSON " + resource.func_199029_a(), e3);
            return null;
        }
    }

    public ResourceLocation getTexture(ResourceLocation location) {
        return this.textures.getOrDefault(location, location);
    }
}

