/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class TrimModel
implements IModelGeometry<TrimModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final float trim;

    public TrimModel(SimpleBlockModel model, float trim) {
        this.model = model;
        this.trim = trim;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        List originalElements = this.model.getElements();
        HashMap<Pair, Float> highest = new HashMap<Pair, Float>();
        HashMap<Pair, BlockPartFace> topFaces = new HashMap<Pair, BlockPartFace>();
        for (BlockPart part : originalElements) {
            Pair xz = Pair.of((Object)Float.valueOf(part.field_178241_a.func_195899_a()), (Object)Float.valueOf(part.field_178241_a.func_195902_c()));
            float height = part.field_178239_b.func_195900_b();
            BlockPartFace face = (BlockPartFace)part.field_178240_c.get(Direction.UP);
            if (highest.containsKey(xz)) {
                boolean isHighest;
                boolean bl = isHighest = height > ((Float)highest.get(xz)).floatValue();
                if (isHighest) {
                    highest.put(xz, Float.valueOf(height));
                }
                if ((face == null || !isHighest) && topFaces.containsKey(xz)) continue;
                topFaces.put(xz, face);
                continue;
            }
            highest.put(xz, Float.valueOf(height));
            if (face == null) continue;
            topFaces.put(xz, face);
        }
        ArrayList<BlockPart> elements = new ArrayList<BlockPart>();
        for (BlockPart part : originalElements) {
            BlockPartFace topFace;
            float oldHeight;
            Pair xz = Pair.of((Object)Float.valueOf(part.field_178241_a.func_195899_a()), (Object)Float.valueOf(part.field_178241_a.func_195902_c()));
            float newHeight = ((Float)highest.get(xz)).floatValue() - this.trim;
            if (newHeight == 0.0f) {
                newHeight = 0.05f;
            }
            if (newHeight > (oldHeight = part.field_178239_b.func_195900_b())) {
                elements.add(part);
                continue;
            }
            Vector3f to = new Vector3f(part.field_178239_b.func_195899_a(), newHeight, part.field_178239_b.func_195902_c());
            float trimAmount = oldHeight - newHeight;
            if (!(to.func_195900_b() >= part.field_178241_a.func_195900_b())) continue;
            boolean zeroHeight = to.func_195900_b() == part.field_178241_a.func_195900_b();
            EnumMap faces = new EnumMap(Direction.class);
            for (Map.Entry entry : part.field_178240_c.entrySet()) {
                boolean isY;
                Direction side = (Direction)entry.getKey();
                boolean bl = isY = side.func_176740_k() == Direction.Axis.Y;
                if (zeroHeight && !isY) continue;
                if (isY) {
                    faces.put(side, entry.getValue());
                    continue;
                }
                faces.put(side, TrimModel.trimUV((BlockPartFace)entry.getValue(), trimAmount));
            }
            if (!faces.containsKey(Direction.UP) && (topFace = (BlockPartFace)topFaces.get(xz)) != null) {
                faces.put(Direction.UP, topFace);
            }
            elements.add(new BlockPart(part.field_178241_a, to, faces, part.field_178237_d, part.field_178238_e));
        }
        return SimpleBlockModel.bakeModel((IModelConfiguration)owner, elements, (IModelTransform)transform, (ItemOverrideList)overrides, spriteGetter, (ResourceLocation)location);
    }

    private static BlockPartFace trimUV(BlockPartFace face, float amount) {
        BlockFaceUV uv = face.field_178243_e;
        if (uv.field_178351_a == null) {
            return face;
        }
        float[] uvs = Arrays.copyOf(uv.field_178351_a, 4);
        switch (uv.field_178350_b) {
            case 0: {
                TrimModel.trim(uvs, amount, 1, 3);
                break;
            }
            case 180: {
                TrimModel.trim(uvs, amount, 3, 1);
                break;
            }
            case 90: {
                TrimModel.trim(uvs, amount, 0, 2);
                break;
            }
            case 270: {
                TrimModel.trim(uvs, amount, 2, 0);
            }
        }
        return new BlockPartFace(face.field_178244_b, face.field_178245_c, face.field_178242_d, new BlockFaceUV(uvs, uv.field_178350_b));
    }

    private static void trim(float[] uvs, float amount, int index, int compare) {
        if (uvs[index] > uvs[compare]) {
            int n = index;
            uvs[n] = uvs[n] - amount;
        } else {
            int n = index;
            uvs[n] = uvs[n] + amount;
        }
    }

    private static class Loader
    implements IModelLoader<TrimModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public TrimModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            float trim = JSONUtils.func_151217_k((JsonObject)json, (String)"trim");
            if (trim <= 0.0f) {
                throw new JsonSyntaxException("trim must be greater than 0");
            }
            return new TrimModel(model, trim);
        }
    }
}

