/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.ingredient;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredientSerializer;
import net.minecraft.network.PacketBuffer;
import slimeknights.mantle.util.JsonHelper;

public abstract class ContentMatchIngredient<T>
implements ICauldronIngredient {
    protected final Serializer<T> serializer;

    protected ContentMatchIngredient(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    protected abstract boolean testValue(T var1);

    protected abstract void write(JsonObject var1);

    protected abstract void write(PacketBuffer var1);

    @Override
    public boolean test(ICauldronContents contents) {
        return contents.get(((Serializer)this.serializer).type).map(this::testValue).orElse(false);
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public static class Serializer<T>
    implements ICauldronIngredientSerializer<ContentMatchIngredient<T>> {
        private final CauldronContentType<T> type;

        public Serializer(CauldronContentType<T> type) {
            this.type = type;
        }

        public ContentMatchIngredient<T> of(T value) {
            return new Single(this, value);
        }

        public ContentMatchIngredient<T> of(Collection<T> values) {
            return new Multi(this, (Set)ImmutableSet.copyOf(values));
        }

        private ContentMatchIngredient<T> getList(List<T> values) {
            if (values.size() == 1) {
                return this.of(values.get(0));
            }
            return this.of((Collection<T>)values);
        }

        @Override
        public ContentMatchIngredient<T> read(JsonObject json) {
            String key = this.type.getKey();
            JsonElement element = JsonHelper.getElement((JsonObject)json, (String)key);
            if (element.isJsonPrimitive()) {
                return this.of(this.type.getValue(element, key));
            }
            if (element.isJsonArray()) {
                List values = JsonHelper.parseList((JsonArray)element.getAsJsonArray(), (String)"names", this.type::getValue);
                return this.getList(values);
            }
            throw new JsonSyntaxException("Invalid '" + this.type.getKey() + "', must be a single value or an array");
        }

        @Override
        public void write(ContentMatchIngredient<T> ingredient, JsonObject json) {
            ingredient.write(json);
        }

        @Override
        public ContentMatchIngredient<T> read(PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            ArrayList<T> values = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                values.add(this.type.read(buffer));
            }
            return this.getList(values);
        }

        @Override
        public void write(ContentMatchIngredient<T> ingredient, PacketBuffer buffer) {
            ingredient.write(buffer);
        }
    }

    private static class Multi<T>
    extends ContentMatchIngredient<T> {
        private final Set<T> values;
        private List<ICauldronContents> displayValues;

        private Multi(Serializer<T> serializer, Set<T> values) {
            super(serializer);
            this.values = values;
        }

        @Override
        protected boolean testValue(T value) {
            return this.values.contains(value);
        }

        @Override
        protected void write(JsonObject json) {
            JsonArray array = new JsonArray();
            for (T value : this.values) {
                array.add(this.serializer.type.toJson(value));
            }
            json.add(this.serializer.type.getKey(), (JsonElement)array);
        }

        @Override
        protected void write(PacketBuffer buffer) {
            buffer.func_150787_b(this.values.size());
            for (T value : this.values) {
                this.serializer.type.write(value, buffer);
            }
        }

        @Override
        public List<ICauldronContents> getMatchingContents() {
            if (this.displayValues == null) {
                this.displayValues = this.values.stream().map(this.serializer.type::of).collect(Collectors.toList());
            }
            return this.displayValues;
        }
    }

    private static class Single<T>
    extends ContentMatchIngredient<T> {
        private final T value;
        private List<ICauldronContents> displayValue;

        private Single(Serializer<T> serializer, T value) {
            super(serializer);
            this.value = value;
        }

        @Override
        protected boolean testValue(T value) {
            return this.value.equals(value);
        }

        @Override
        protected void write(JsonObject json) {
            json.add(this.serializer.type.getKey(), this.serializer.type.toJson(this.value));
        }

        @Override
        protected void write(PacketBuffer buffer) {
            buffer.func_150787_b(1);
            this.serializer.type.write(this.value, buffer);
        }

        @Override
        public List<ICauldronContents> getMatchingContents() {
            if (this.displayValue == null) {
                this.displayValue = Collections.singletonList(this.serializer.type.of(this.value));
            }
            return this.displayValue;
        }
    }
}

