/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.recipe;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronIngredients;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.AbstractCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.LevelPredicate;
import knightminer.inspirations.library.recipe.cauldron.util.LevelUpdate;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.SizedIngredient;

public class CauldronRecipe
extends AbstractCauldronRecipe
implements ICauldronRecipe {
    private final ResourceLocation id;
    private final String group;
    private final SizedIngredient input;
    private final ItemStack output;
    private final boolean copyNBT;
    private final LevelUpdate levelUpdate;
    @Nullable
    private final ItemStack container;
    private final SoundEvent sound;

    public CauldronRecipe(ResourceLocation id, String group, SizedIngredient input, ICauldronIngredient contents, LevelPredicate level, TemperaturePredicate temperature, ItemStack output, boolean copyNBT, @Nullable ICauldronContents newContents, LevelUpdate levelUpdate, @Nullable ItemStack container, SoundEvent sound) {
        super(contents, level, temperature, newContents);
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.copyNBT = copyNBT;
        this.levelUpdate = levelUpdate;
        this.container = container;
        this.sound = sound;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        if (inv.isSimple() && this.outputContents != null && !this.outputContents.isSimple()) {
            return false;
        }
        if (!this.matches(inv)) {
            return false;
        }
        ItemStack stack = inv.getStack();
        return this.input == SizedIngredient.EMPTY || this.input.test(stack);
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inventory) {
        if (!inventory.updateLevel(this.levelUpdate) && this.outputContents != null) {
            inventory.setContents(this.outputContents);
        }
        ItemStack original = inventory.getStack();
        CompoundNBT originalTag = original.func_77978_p();
        ItemStack container = this.container;
        if (container == null) {
            container = original.getContainerItem().func_77946_l();
            if (!container.func_190926_b()) {
                container.func_190920_e(this.input.getAmountNeeded());
            }
        } else {
            container = container.func_77946_l();
        }
        inventory.shrinkStack(this.input.getAmountNeeded());
        inventory.setOrGiveStack(container);
        if (!this.output.func_190926_b()) {
            ItemStack output = this.output.func_77946_l();
            if (this.copyNBT && originalTag != null) {
                output.func_77982_d(originalTag.func_74737_b());
            }
            inventory.setOrGiveStack(output);
        }
        inventory.playSound(this.sound);
    }

    @Override
    public List<ItemStack> getItemInputs() {
        return this.input.getMatchingStacks();
    }

    @Override
    public int getLevelInput() {
        return this.levelUpdate == LevelUpdate.IDENTITY ? this.level.getMax() : this.level.getMin();
    }

    @Override
    public int getLevelOutput() {
        return this.levelUpdate.applyAsInt(this.getLevelInput());
    }

    @Override
    public ItemStack getItemOutput() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON;
    }

    public static class Serializer
    extends RecipeSerializer<CauldronRecipe> {
        public static SoundEvent getSound(ResourceLocation name, SoundEvent def) {
            if (ForgeRegistries.SOUND_EVENTS.containsKey(name)) {
                return (SoundEvent)Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getValue(name));
            }
            return def;
        }

        public CauldronRecipe read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            JsonObject inputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
            SizedIngredient input = SizedIngredient.EMPTY;
            if (inputJson.has("item")) {
                input = SizedIngredient.deserialize((JsonObject)JSONUtils.func_152754_s((JsonObject)inputJson, (String)"item"));
            }
            ICauldronIngredient contents = CauldronIngredients.read(JSONUtils.func_152754_s((JsonObject)inputJson, (String)"contents"));
            LevelPredicate levels = LevelPredicate.read(JSONUtils.func_152754_s((JsonObject)inputJson, (String)"level"));
            TemperaturePredicate temperature = AbstractCauldronRecipe.getBoiling(inputJson, "temperature");
            JsonObject outputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"output");
            ItemStack output = ItemStack.field_190927_a;
            boolean copyNBT = false;
            if (outputJson.has("item")) {
                output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)outputJson, (String)"item"), (boolean)true);
                copyNBT = JSONUtils.func_151209_a((JsonObject)outputJson, (String)"copy_nbt", (boolean)false);
            }
            ICauldronContents newContents = null;
            if (outputJson.has("contents")) {
                newContents = CauldronContentTypes.read(JSONUtils.func_152754_s((JsonObject)outputJson, (String)"contents"));
            }
            LevelUpdate levelUpdate = LevelUpdate.IDENTITY;
            if (outputJson.has("level")) {
                levelUpdate = LevelUpdate.read(JSONUtils.func_152754_s((JsonObject)outputJson, (String)"level"));
            }
            ItemStack container = null;
            if (outputJson.has("container")) {
                JsonObject data = JSONUtils.func_152754_s((JsonObject)outputJson, (String)"container");
                boolean empty = JSONUtils.func_151209_a((JsonObject)data, (String)"empty", (boolean)false);
                container = empty ? ItemStack.field_190927_a : CraftingHelper.getItemStack((JsonObject)data, (boolean)true);
            }
            SoundEvent sound = SoundEvents.field_187547_bF;
            if (json.has("sound")) {
                sound = Serializer.getSound(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"sound")), sound);
            }
            return new CauldronRecipe(id, group, input, contents, levels, temperature, output, copyNBT, newContents, levelUpdate, container, sound);
        }

        public void write(PacketBuffer buffer, CauldronRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.write(buffer);
            CauldronIngredients.write(recipe.ingredient, buffer);
            recipe.level.write(buffer);
            buffer.func_179249_a((Enum)recipe.temperature);
            buffer.func_150788_a(recipe.output);
            buffer.writeBoolean(recipe.copyNBT);
            if (recipe.outputContents != null) {
                buffer.writeBoolean(true);
                recipe.outputContents.write(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            recipe.levelUpdate.write(buffer);
            if (recipe.container == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.func_150788_a(recipe.container);
            }
            buffer.func_192572_a(Objects.requireNonNull(recipe.sound.getRegistryName()));
        }

        @Nullable
        public CauldronRecipe read(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_218666_n();
            SizedIngredient input = SizedIngredient.read((PacketBuffer)buffer);
            ICauldronIngredient contents = CauldronIngredients.read(buffer);
            LevelPredicate levels = LevelPredicate.read(buffer);
            TemperaturePredicate boiling = (TemperaturePredicate)buffer.func_179257_a(TemperaturePredicate.class);
            ItemStack output = buffer.func_150791_c();
            boolean copyNBT = buffer.readBoolean();
            ICauldronContents newContents = null;
            if (buffer.readBoolean()) {
                newContents = CauldronContentTypes.read(buffer);
            }
            LevelUpdate levelUpdate = LevelUpdate.read(buffer);
            ItemStack container = null;
            if (buffer.readBoolean()) {
                container = buffer.func_150791_c();
            }
            SoundEvent sound = Serializer.getSound(buffer.func_192575_l(), SoundEvents.field_187547_bF);
            return new CauldronRecipe(id, group, input, contents, levels, boiling, output, copyNBT, newContents, levelUpdate, container, sound);
        }
    }
}

