/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronIngredients;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.util.LevelPredicate;
import knightminer.inspirations.library.recipe.cauldron.util.LevelUpdate;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import slimeknights.mantle.recipe.SizedIngredient;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;

public class CauldronRecipeBuilder
extends AbstractRecipeBuilder<CauldronRecipeBuilder> {
    private final SizedIngredient input;
    private final ICauldronIngredient contents;
    private LevelPredicate levels;
    private TemperaturePredicate temperature = TemperaturePredicate.ANY;
    private ItemStack output = ItemStack.field_190927_a;
    private boolean copyNBT = false;
    @Nullable
    private ICauldronContents newContents = null;
    private LevelUpdate levelUpdate = LevelUpdate.IDENTITY;
    @Nullable
    private ItemStack container = null;
    private SoundEvent sound = null;

    private CauldronRecipeBuilder(SizedIngredient input, ICauldronIngredient contents) {
        this.input = input;
        this.contents = contents;
    }

    public static CauldronRecipeBuilder cauldron(SizedIngredient input, ICauldronIngredient contents) {
        return new CauldronRecipeBuilder(input, contents);
    }

    public static CauldronRecipeBuilder cauldron(ICauldronIngredient contents) {
        return CauldronRecipeBuilder.cauldron(SizedIngredient.EMPTY, contents);
    }

    public CauldronRecipeBuilder minLevels(int min) {
        this.levels = LevelPredicate.min(min);
        return this;
    }

    public CauldronRecipeBuilder maxLevels(int max) {
        this.levels = LevelPredicate.max(max);
        return this;
    }

    public CauldronRecipeBuilder matchEmpty() {
        return this.maxLevels(0);
    }

    public CauldronRecipeBuilder matchFull() {
        return this.minLevels(12);
    }

    public CauldronRecipeBuilder levelRange(int min, int max) {
        this.levels = LevelPredicate.range(min, max);
        return this;
    }

    public CauldronRecipeBuilder setTemperature(TemperaturePredicate temp) {
        this.temperature = temp;
        return this;
    }

    public CauldronRecipeBuilder setOutput(ItemStack output) {
        this.output = output;
        return this;
    }

    public CauldronRecipeBuilder setOutput(IItemProvider output) {
        return this.setOutput(new ItemStack(output));
    }

    public CauldronRecipeBuilder setCopyNBT() {
        this.copyNBT = true;
        return this;
    }

    public CauldronRecipeBuilder setContainer(ItemStack container) {
        this.container = container;
        return this;
    }

    public CauldronRecipeBuilder noContainer() {
        return this.setContainer(ItemStack.field_190927_a);
    }

    public CauldronRecipeBuilder setContainer(IItemProvider container) {
        return this.setContainer(new ItemStack(container));
    }

    public CauldronRecipeBuilder setOutput(ICauldronContents contents) {
        this.newContents = contents;
        return this;
    }

    public CauldronRecipeBuilder setLevels(int levels) {
        this.levelUpdate = LevelUpdate.set(levels);
        return this;
    }

    public CauldronRecipeBuilder setFull() {
        return this.setLevels(12);
    }

    public CauldronRecipeBuilder setEmpty() {
        return this.setLevels(0);
    }

    public CauldronRecipeBuilder addLevels(int levels) {
        this.levelUpdate = LevelUpdate.add(levels);
        return this;
    }

    public CauldronRecipeBuilder setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation name;
        if (!this.output.func_190926_b()) {
            this.build(consumer, Objects.requireNonNull(this.output.func_77973_b().getRegistryName()));
            return;
        }
        if (this.newContents != null && (name = CauldronRecipeBuilder.nameFromContents(this.newContents)) != null) {
            this.build(consumer, name);
        }
        throw new IllegalStateException("Unable to create automatic recipe ID");
    }

    @Nullable
    public static ResourceLocation nameFromContents(ICauldronContents contents) {
        Optional<Fluid> fluid = contents.get(CauldronContentTypes.FLUID);
        if (fluid.isPresent()) {
            return Objects.requireNonNull(fluid.get().getRegistryName());
        }
        Optional<Potion> potion = contents.get(CauldronContentTypes.POTION);
        if (potion.isPresent()) {
            return Objects.requireNonNull(potion.get().getRegistryName());
        }
        Optional<ResourceLocation> custom = contents.get(CauldronContentTypes.CUSTOM);
        return custom.orElse(null);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.levels == null) {
            throw new IllegalStateException("No levels defined for cauldron recipe " + id + "!");
        }
        ResourceLocation advancementId = this.buildAdvancement(id, "cauldron");
        consumer.accept(new Result(id, this.group, this.input, this.contents, this.levels, this.temperature, this.output, this.copyNBT, this.newContents, this.levelUpdate, this.container, this.sound, this.advancementBuilder, advancementId));
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final SizedIngredient input;
        private final ICauldronIngredient contents;
        private final LevelPredicate level;
        private final TemperaturePredicate temperature;
        private final ItemStack output;
        private final boolean copyNBT;
        @Nullable
        private final ICauldronContents newContents;
        private final LevelUpdate levelUpdate;
        @Nullable
        private final ItemStack container;
        @Nullable
        private final SoundEvent sound;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        private Result(ResourceLocation id, String group, SizedIngredient input, ICauldronIngredient contents, LevelPredicate level, TemperaturePredicate temperature, ItemStack output, boolean copyNBT, @Nullable ICauldronContents newContents, LevelUpdate levelUpdate, @Nullable ItemStack container, @Nullable SoundEvent sound, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.input = input;
            this.contents = contents;
            this.level = level;
            this.temperature = temperature;
            this.output = output;
            this.copyNBT = copyNBT;
            this.newContents = newContents;
            this.levelUpdate = levelUpdate;
            this.container = container;
            this.sound = sound;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        private static JsonObject toJson(ItemStack stack) {
            JsonObject item = new JsonObject();
            item.addProperty("item", Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString());
            if (stack.func_190916_E() != 1) {
                item.addProperty("count", (Number)stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                assert (stack.func_77978_p() != null);
                item.addProperty("nbt", stack.func_77978_p().toString());
            }
            return item;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonObject inputJson = new JsonObject();
            if (this.input != SizedIngredient.EMPTY) {
                inputJson.add("item", (JsonElement)this.input.serialize());
            }
            inputJson.add("contents", (JsonElement)CauldronIngredients.toJson(this.contents));
            inputJson.add("level", (JsonElement)this.level.toJson());
            if (this.temperature != TemperaturePredicate.ANY) {
                inputJson.addProperty("temperature", this.temperature.getName());
            }
            json.add("input", (JsonElement)inputJson);
            JsonObject outputJson = new JsonObject();
            if (!this.output.func_190926_b()) {
                outputJson.add("item", (JsonElement)Result.toJson(this.output));
                if (this.copyNBT) {
                    outputJson.addProperty("copy_nbt", Boolean.valueOf(true));
                }
            }
            if (this.container != null) {
                if (this.container.func_190926_b()) {
                    JsonObject item = new JsonObject();
                    item.addProperty("empty", Boolean.valueOf(true));
                    outputJson.add("container", (JsonElement)item);
                } else {
                    outputJson.add("container", (JsonElement)Result.toJson(this.container));
                }
            }
            if (this.newContents != null) {
                outputJson.add("contents", (JsonElement)this.newContents.toJson());
            }
            if (this.levelUpdate != LevelUpdate.IDENTITY) {
                outputJson.add("level", (JsonElement)this.levelUpdate.toJson());
            }
            json.add("output", (JsonElement)outputJson);
            if (this.sound != null) {
                json.addProperty("sound", Objects.requireNonNull(this.sound.getRegistryName()).toString());
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return RecipeSerializers.CAULDRON;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

