/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.special;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.DynamicFinishedRecipe;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.DisplayCauldronRecipe;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.util.JsonHelper;

public abstract class DyeableCauldronRecipe
implements ICauldronRecipe,
IMultiRecipe<DisplayCauldronRecipe> {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private List<DisplayCauldronRecipe> displayRecipes;

    public DyeableCauldronRecipe(ResourceLocation id, Ingredient ingredient) {
        this.id = id;
        this.ingredient = ingredient;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        ItemStack stack = inv.getStack();
        return inv.getLevel() >= 4 && this.ingredient.test(stack) && this.matches(inv.getContents(), stack);
    }

    protected abstract boolean matches(ICauldronContents var1, ItemStack var2);

    @Override
    public void handleRecipe(IModifyableCauldronInventory inventory) {
        inventory.setOrGiveStack(this.updateColor(inventory.getContents(), inventory.splitStack(1)));
        inventory.addLevel(-4);
        inventory.playSound(SoundEvents.field_187547_bF);
    }

    protected abstract ItemStack updateColor(ICauldronContents var1, ItemStack var2);

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    protected abstract Stream<DisplayCauldronRecipe> getDisplayRecipes(ItemStack var1);

    public List<DisplayCauldronRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            this.displayRecipes = Arrays.stream(this.ingredient.func_193365_a()).flatMap(this::getDisplayRecipes).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    public static class FinishedRecipe
    extends DynamicFinishedRecipe {
        private final Ingredient ingredient;

        private FinishedRecipe(ResourceLocation id, Ingredient ingredient, Serializer serializer) {
            super(id, serializer);
            this.ingredient = ingredient;
        }

        public static FinishedRecipe recipe(ResourceLocation id, Ingredient ingredient, Serializer serializer) {
            return new FinishedRecipe(id, ingredient, serializer);
        }

        public static FinishedRecipe dye(ResourceLocation id, Ingredient ingredient) {
            return new FinishedRecipe(id, ingredient, RecipeSerializers.CAULDRON_DYE_DYEABLE);
        }

        public static FinishedRecipe clear(ResourceLocation id, Ingredient ingredient) {
            return new FinishedRecipe(id, ingredient, RecipeSerializers.CAULDRON_CLEAR_DYEABLE);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.ingredient.func_200304_c());
        }
    }

    public static class Serializer
    extends RecipeSerializer<DyeableCauldronRecipe> {
        private final BiFunction<ResourceLocation, Ingredient, DyeableCauldronRecipe> factory;

        public Serializer(BiFunction<ResourceLocation, Ingredient, DyeableCauldronRecipe> factory) {
            this.factory = factory;
        }

        public DyeableCauldronRecipe read(ResourceLocation id, JsonObject json) {
            return this.factory.apply(id, Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient")));
        }

        @Nullable
        public DyeableCauldronRecipe read(ResourceLocation id, PacketBuffer buffer) {
            return this.factory.apply(id, Ingredient.func_199566_b((PacketBuffer)buffer));
        }

        public void write(PacketBuffer buffer, DyeableCauldronRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
        }
    }

    public static class Clear
    extends DyeableCauldronRecipe {
        public Clear(ResourceLocation id, Ingredient ingredient) {
            super(id, ingredient);
        }

        @Override
        protected boolean matches(ICauldronContents contents, ItemStack stack) {
            return contents.contains(CauldronContentTypes.FLUID, Fluids.field_204546_a) && Util.hasColor(stack);
        }

        @Override
        protected ItemStack updateColor(ICauldronContents contents, ItemStack stack) {
            return Util.clearColor(stack);
        }

        @Override
        protected Stream<DisplayCauldronRecipe> getDisplayRecipes(ItemStack stack) {
            List<ItemStack> inputs = Arrays.stream(DyeColor.values()).map(color -> Util.setColor(stack.func_77946_l(), color.getColorValue())).collect(Collectors.toList());
            return Stream.of(DisplayCauldronRecipe.builder(4, 0).setItemInputs(inputs).setContentInputs((List)DisplayCauldronRecipe.WATER_CONTENTS.get()).setItemOutput(Util.clearColor(stack.func_77946_l())).build());
        }

        public IRecipeSerializer<?> func_199559_b() {
            return RecipeSerializers.CAULDRON_CLEAR_DYEABLE;
        }
    }

    public static class Dye
    extends DyeableCauldronRecipe {
        private List<DisplayCauldronRecipe> displayRecipes;

        public Dye(ResourceLocation id, Ingredient ingredient) {
            super(id, ingredient);
        }

        @Override
        protected boolean matches(ICauldronContents contents, ItemStack stack) {
            return contents.get(CauldronContentTypes.COLOR).filter(color -> !Util.hasColor(stack) || Util.getColor(stack) != color).isPresent();
        }

        @Override
        protected ItemStack updateColor(ICauldronContents contents, ItemStack stack) {
            int color = contents.get(CauldronContentTypes.COLOR).orElse(-1);
            return Util.setColor(stack, color);
        }

        @Override
        protected Stream<DisplayCauldronRecipe> getDisplayRecipes(ItemStack stack) {
            List<ItemStack> inputs = Collections.singletonList(stack);
            return Arrays.stream(DyeColor.values()).map(color -> DisplayCauldronRecipe.builder(4, 0).setItemInputs(inputs).setContentInputs(CauldronContentTypes.DYE.of((DyeColor)color)).setItemOutput(Util.setColor(stack.func_77946_l(), color.getColorValue())).build());
        }

        public IRecipeSerializer<?> func_199559_b() {
            return RecipeSerializers.CAULDRON_DYE_DYEABLE;
        }
    }
}

