/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipeDisplay;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class DisplayCauldronRecipe
implements ICauldronRecipeDisplay {
    public static final Lazy<List<ICauldronContents>> WATER_CONTENTS = Lazy.of(() -> Collections.singletonList(CauldronContentTypes.DEFAULT.get()));
    public static final Lazy<List<FluidStack>> WATER_FLUID = Lazy.of(() -> Collections.singletonList(new FluidStack((Fluid)Fluids.field_204546_a, 1000)));
    private final List<ItemStack> itemInputs;
    private final List<ICauldronContents> contentInputs;
    private final List<FluidStack> fluidInputs;
    private final int levelInput;
    private final ItemStack itemOutput;
    private final ICauldronContents contentOutputs;
    private final FluidStack fluidOutput;
    private final int levelOutput;
    private final TemperaturePredicate temperature;
    private final int time;

    private DisplayCauldronRecipe(List<ItemStack> itemInputs, List<ICauldronContents> contentInputs, List<FluidStack> fluidInputs, int levelInput, ItemStack itemOutput, ICauldronContents contentOutputs, FluidStack fluidOutput, int levelOutput, TemperaturePredicate temperature, int time) {
        this.fluidInputs = fluidInputs;
        this.levelInput = levelInput;
        this.itemInputs = itemInputs;
        this.contentInputs = contentInputs;
        this.fluidOutput = fluidOutput;
        this.levelOutput = levelOutput;
        this.itemOutput = itemOutput;
        this.contentOutputs = contentOutputs;
        this.temperature = temperature;
        this.time = time;
    }

    public static Builder builder(int levelInput, int levelOutput) {
        return new Builder(levelInput, levelOutput);
    }

    public static Builder builder(int level) {
        return DisplayCauldronRecipe.builder(level, level);
    }

    public static Optional<FluidStack> getFluid(ICauldronContents contents) {
        return contents.get(CauldronContentTypes.FLUID).map(fluid -> new FluidStack(fluid, 1000));
    }

    @Override
    public List<ItemStack> getItemInputs() {
        return this.itemInputs;
    }

    @Override
    public List<ICauldronContents> getContentInputs() {
        return this.contentInputs;
    }

    @Override
    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    @Override
    public int getLevelInput() {
        return this.levelInput;
    }

    @Override
    public ItemStack getItemOutput() {
        return this.itemOutput;
    }

    @Override
    public ICauldronContents getContentOutput() {
        return this.contentOutputs;
    }

    @Override
    public FluidStack getFluidOutput() {
        return this.fluidOutput;
    }

    @Override
    public int getLevelOutput() {
        return this.levelOutput;
    }

    @Override
    public TemperaturePredicate getTemperature() {
        return this.temperature;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public static class Builder {
        private final int levelInput;
        private final int levelOutput;
        private List<ItemStack> itemInputs = Collections.emptyList();
        private List<ICauldronContents> contentInputs = Collections.emptyList();
        private ItemStack itemOutput = ItemStack.field_190927_a;
        private ICauldronContents contentOutputs;
        private TemperaturePredicate temperature = TemperaturePredicate.ANY;
        private int time = -1;

        private Builder(int levelInput, int levelOutput) {
            this.levelInput = MathHelper.func_76125_a((int)levelInput, (int)0, (int)12);
            this.levelOutput = MathHelper.func_76125_a((int)levelOutput, (int)0, (int)12);
        }

        public Builder setItemInputs(List<ItemStack> input) {
            this.itemInputs = input;
            return this;
        }

        public Builder setItemInputs(ItemStack input) {
            return this.setItemInputs(Collections.singletonList(input));
        }

        public Builder setItemInputs(IItemProvider input) {
            return this.setItemInputs(new ItemStack(input));
        }

        public Builder setContentInputs(List<ICauldronContents> input) {
            if (this.levelInput != 0) {
                this.contentInputs = input;
            }
            return this;
        }

        public Builder setContentInputs(ICauldronContents input) {
            return this.setContentInputs(Collections.singletonList(input));
        }

        public Builder setItemOutput(ItemStack output) {
            this.itemOutput = output;
            return this;
        }

        public Builder setItemOutput(IItemProvider output) {
            return this.setItemOutput(new ItemStack(output));
        }

        public Builder setContentOutput(ICauldronContents output) {
            if (this.levelOutput != 0) {
                this.contentOutputs = output;
            }
            return this;
        }

        public Builder setTemperature(TemperaturePredicate temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder setTime(int time) {
            this.time = time;
            return this;
        }

        public DisplayCauldronRecipe build() {
            List fluidInputs = Collections.emptyList();
            if (this.levelInput != 0) {
                if (this.contentInputs.isEmpty()) {
                    throw new IllegalStateException("Invalid recipe, must have at least one input for level greater than 0");
                }
                fluidInputs = this.contentInputs.stream().flatMap(contents -> DisplayCauldronRecipe.getFluid(contents).map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
                if (fluidInputs.size() != this.contentInputs.size()) {
                    fluidInputs = Collections.emptyList();
                }
            }
            FluidStack fluidOutput = FluidStack.EMPTY;
            if (this.levelOutput != 0) {
                if (this.contentOutputs == null) {
                    throw new IllegalStateException("Invalid recipe, must have at least one output for level greater than 0");
                }
                fluidOutput = DisplayCauldronRecipe.getFluid(this.contentOutputs).orElse(FluidStack.EMPTY);
            } else {
                this.contentOutputs = (ICauldronContents)CauldronContentTypes.DEFAULT.get();
            }
            return new DisplayCauldronRecipe(this.itemInputs, this.contentInputs, fluidInputs, this.levelInput, this.itemOutput, this.contentOutputs, fluidOutput, this.levelOutput, this.temperature, this.time);
        }
    }
}

