/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.library.recipe.RecipeTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipeDisplay;
import knightminer.inspirations.plugins.jei.cauldron.CauldronCategory;
import knightminer.inspirations.plugins.jei.cauldron.CauldronContentHelper;
import knightminer.inspirations.plugins.jei.cauldron.CauldronRenderer;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.recipe.IMultiRecipe;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static IIngredientManager ingedientManager;
    public static final IIngredientType<ICauldronContents> CAULDRON_CONTENTS;
    private static final List<HideState> HIDABLE_ITEMS;
    private static List<ICauldronRecipeDisplay> recipes;

    public ResourceLocation getPluginUid() {
        return Inspirations.getResource("jei");
    }

    private static List<ICauldronRecipeDisplay> getCauldronRecipes() {
        assert (Minecraft.func_71410_x().field_71441_e != null);
        RecipeManager manager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        boolean isExtended = Config.extendedCauldron.getAsBoolean();
        Stream allRecipes = manager.func_215366_a(RecipeTypes.CAULDRON).values().stream();
        if (isExtended) {
            allRecipes = Stream.concat(allRecipes, manager.func_215366_a(RecipeTypes.CAULDRON_TRANSFORM).values().stream());
        }
        Stream<ICauldronRecipeDisplay> recipes = allRecipes.sorted((r1, r2) -> {
            boolean m1 = r1 instanceof IMultiRecipe;
            boolean m2 = r2 instanceof IMultiRecipe;
            if (m1 && !m2) {
                return 1;
            }
            return !m1 && m2 ? -1 : r1.func_199560_c().compareTo(r2.func_199560_c());
        }).flatMap(recipe -> recipe instanceof IMultiRecipe ? ((IMultiRecipe)recipe).getRecipes().stream() : Stream.of(recipe)).filter(recipe -> recipe instanceof ICauldronRecipeDisplay).map(recipe -> (ICauldronRecipeDisplay)recipe).filter(ICauldronRecipeDisplay::isSimple);
        if (!isExtended) {
            recipes = recipes.filter(recipe -> recipe.getContentOutput().isSimple() && recipe.getContentInputs().stream().allMatch(ICauldronContents::isSimple));
        }
        return recipes.collect(Collectors.toList());
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        if (Config.cauldronRecipes.getAsBoolean()) {
            List contents;
            if (Config.extendedCauldron.getAsBoolean()) {
                contents = new ArrayList();
                contents.addAll(ForgeRegistries.POTION_TYPES.getValues().stream().map(CauldronContentTypes.POTION::of).collect(Collectors.toList()));
                contents.addAll(Arrays.stream(DyeColor.values()).map(CauldronContentTypes.DYE::of).collect(Collectors.toList()));
                recipes = JEIPlugin.getCauldronRecipes();
                contents.addAll(recipes.stream().map(ICauldronRecipeDisplay::getContentOutput).filter(c -> c.contains(CauldronContentTypes.CUSTOM)).distinct().collect(Collectors.toList()));
                contents = contents.stream().filter(content -> !content.contains(CauldronContentTypes.FLUID)).distinct().collect(Collectors.toList());
            } else {
                contents = Collections.emptyList();
            }
            registration.register(CAULDRON_CONTENTS, contents, (IIngredientHelper)CauldronContentHelper.INSTANCE, (IIngredientRenderer)CauldronRenderer.LIST);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (Config.cauldronRecipes.getAsBoolean()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new CauldronCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Config.cauldronRecipes.getAsBoolean()) {
            if (recipes == null) {
                recipes = JEIPlugin.getCauldronRecipes();
            }
            registration.addRecipes(recipes, CauldronCategory.ID);
            recipes = null;
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (Config.cauldronRecipes.getAsBoolean()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_150383_bp), new ResourceLocation[]{CauldronCategory.ID});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        ISubtypeInterpreter texture = RetexturedBlockItem::getTextureName;
        Consumer<IItemProvider> setTextureSubtype = item -> registry.registerSubtypeInterpreter(item.func_199767_j(), texture);
        InspirationsBuilding.shelf.values().forEach(setTextureSubtype);
        InspirationsBuilding.enlightenedBush.values().forEach(setTextureSubtype);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ingedientManager = jeiRuntime.getIngredientManager();
        HIDABLE_ITEMS.clear();
        for (ItemStack item : ingedientManager.getAllIngredients(VanillaTypes.ITEM)) {
            if (!(item.func_77973_b() instanceof IHidable)) continue;
            HIDABLE_ITEMS.add(new HideState(item));
        }
        Config.setJEIUpdateRunnable(JEIPlugin::updateHiddenItems);
    }

    private static void updateHiddenItems() {
        ArrayList<ItemStack> hidden = new ArrayList<ItemStack>();
        ArrayList<ItemStack> visible = new ArrayList<ItemStack>();
        for (HideState state : HIDABLE_ITEMS) {
            boolean enabled = ((IHidable)state.stack.func_77973_b()).isEnabled();
            if (enabled == state.visible) continue;
            if (enabled) {
                visible.add(state.stack);
            } else {
                hidden.add(state.stack);
            }
            state.visible = enabled;
        }
        if (hidden.size() > 0) {
            ingedientManager.removeIngredientsAtRuntime(VanillaTypes.ITEM, hidden);
        }
        if (visible.size() > 0) {
            ingedientManager.addIngredientsAtRuntime(VanillaTypes.ITEM, visible);
        }
    }

    static {
        CAULDRON_CONTENTS = () -> ICauldronContents.class;
        HIDABLE_ITEMS = new ArrayList<HideState>();
    }

    private static class HideState {
        private final ItemStack stack;
        private boolean visible;

        private HideState(ItemStack item) {
            this.stack = item;
            this.visible = true;
        }
    }
}

