/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipeDisplay;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import knightminer.inspirations.plugins.jei.JEIPlugin;
import knightminer.inspirations.plugins.jei.cauldron.CauldronRenderer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;

public class CauldronCategory
implements IRecipeCategory<ICauldronRecipeDisplay> {
    public static final ResourceLocation ID = Inspirations.getResource("cauldron");
    private static final ResourceLocation BACKGROUND_LOC = Inspirations.getResource("textures/gui/jei/cauldron.png");
    public static final String TRANSLATION_KEY = Util.func_200697_a((String)"jei", (ResourceLocation)ID);
    private static final String KEY_TIME = TRANSLATION_KEY + ".time";
    private static final String KEY_BOILING = TRANSLATION_KEY + ".boiling";
    private static final String KEY_WARM = TRANSLATION_KEY + ".warm";
    private static final String KEY_FREEZING = TRANSLATION_KEY + ".freezing";
    private static final String KEY_COOL = TRANSLATION_KEY + ".cool";
    private static final String KEY_NORMAL = TRANSLATION_KEY + ".normal";
    private final String title = ForgeI18n.getPattern((String)TRANSLATION_KEY);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable boiling;
    private final IDrawable warm;
    private final IDrawable cool;
    private final IDrawable freezing;
    private final IDrawableAnimated arrow;

    public CauldronCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(BACKGROUND_LOC, 0, 0, 86, 51).addPadding(0, 0, 0, 8).build();
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_150383_bp));
        this.boiling = helper.createDrawable(BACKGROUND_LOC, 86, 0, 14, 14);
        this.cool = helper.createDrawable(BACKGROUND_LOC, 100, 0, 14, 14);
        this.freezing = helper.createDrawable(BACKGROUND_LOC, 86, 14, 8, 16);
        this.warm = helper.createDrawable(BACKGROUND_LOC, 94, 14, 8, 16);
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 86, 30, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends ICauldronRecipeDisplay> getRecipeClass() {
        return ICauldronRecipeDisplay.class;
    }

    public void setIngredients(ICauldronRecipeDisplay recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemInputs()));
        ItemStack outputItem = recipe.getItemOutput();
        if (!outputItem.func_190926_b()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)outputItem);
        }
        if (recipe.getLevelInput() > 0) {
            List<FluidStack> fluids = recipe.getFluidInputs();
            if (fluids.isEmpty()) {
                ingredients.setInputLists(JEIPlugin.CAULDRON_CONTENTS, Collections.singletonList(recipe.getContentInputs()));
            } else {
                ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(fluids));
            }
        }
        if (recipe.getLevelOutput() > 0) {
            FluidStack outputFluid = recipe.getFluidOutput();
            if (outputFluid.isEmpty()) {
                ingredients.setOutput(JEIPlugin.CAULDRON_CONTENTS, (Object)recipe.getContentOutput());
            } else {
                ingredients.setOutput(VanillaTypes.FLUID, (Object)outputFluid);
            }
        }
    }

    public void setRecipe(IRecipeLayout layout, ICauldronRecipeDisplay recipe, IIngredients ingredients) {
        int output;
        int input;
        IGuiItemStackGroup items = layout.getItemStacks();
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        IGuiIngredientGroup contents = layout.getIngredientsGroup(JEIPlugin.CAULDRON_CONTENTS);
        items.init(0, true, 9, 1);
        if (!recipe.getItemOutput().func_190926_b()) {
            items.init(1, false, 67, 1);
        }
        if ((input = recipe.getLevelInput()) > 0) {
            if (recipe.getFluidInputs().isEmpty()) {
                contents.init(0, true, (IIngredientRenderer)CauldronRenderer.contentLevel(input), 10, 18, 16, 14, 2, 1);
            } else {
                fluids.init(0, true, (IIngredientRenderer)CauldronRenderer.fluidLevel(input), 10, 18, 16, 14, 2, 1);
            }
        }
        if ((output = recipe.getLevelOutput()) > 0) {
            if (recipe.getFluidOutput().isEmpty()) {
                contents.init(1, false, (IIngredientRenderer)CauldronRenderer.contentLevel(output), 68, 18, 16, 14, 2, 1);
            } else {
                fluids.init(1, false, (IIngredientRenderer)CauldronRenderer.fluidLevel(output), 68, 18, 16, 14, 2, 1);
            }
        }
        items.set(ingredients);
        fluids.set(ingredients);
        contents.set(ingredients);
    }

    public void draw(ICauldronRecipeDisplay recipe, MatrixStack matrices, double mouseX, double mouseY) {
        int time = recipe.getTime();
        if (time > 0) {
            String timeString = I18n.func_135052_a((String)KEY_TIME, (Object[])new Object[]{time / 20});
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int x = 46 - fontRenderer.func_78256_a(timeString) / 2;
            fontRenderer.func_238421_b_(matrices, timeString, (float)x, 4.0f, Color.GRAY.getRGB());
            this.arrow.draw(matrices, 35, 17);
        }
        switch (recipe.getTemperature()) {
            case BOILING: {
                this.boiling.draw(matrices, 11, 35);
                break;
            }
            case WARM: {
                this.warm.draw(matrices, 2, 18);
                this.warm.draw(matrices, 26, 18);
                break;
            }
            case FREEZING: {
                this.freezing.draw(matrices, 2, 18);
                this.freezing.draw(matrices, 26, 18);
                break;
            }
            case COOL: {
                this.cool.draw(matrices, 11, 35);
                break;
            }
            case NORMAL: {
                this.warm.draw(matrices, 2, 18);
                this.warm.draw(matrices, 26, 18);
                this.cool.draw(matrices, 11, 35);
            }
        }
    }

    public List<ITextComponent> getTooltipStrings(ICauldronRecipeDisplay recipe, double mouseX, double mouseY) {
        String tooltip = null;
        TemperaturePredicate temperature = recipe.getTemperature();
        if (mouseX >= 11.0 && mouseX < 25.0 && mouseY >= 35.0 && mouseY < 49.0) {
            if (temperature == TemperaturePredicate.BOILING) {
                tooltip = KEY_BOILING;
            } else if (temperature == TemperaturePredicate.COOL) {
                tooltip = KEY_COOL;
            } else if (temperature == TemperaturePredicate.NORMAL) {
                tooltip = KEY_NORMAL;
            }
        }
        if (tooltip == null && (mouseX >= 2.0 && mouseX < 10.0 && mouseY >= 18.0 && mouseY < 34.0 || mouseX >= 26.0 && mouseX < 34.0 && mouseY >= 18.0 && mouseY < 34.0)) {
            if (temperature == TemperaturePredicate.FREEZING) {
                tooltip = KEY_FREEZING;
            } else if (temperature == TemperaturePredicate.WARM) {
                tooltip = KEY_WARM;
            } else if (temperature == TemperaturePredicate.NORMAL) {
                tooltip = KEY_NORMAL;
            }
        }
        if (tooltip != null) {
            return Collections.singletonList(new TranslationTextComponent(tooltip));
        }
        return Collections.emptyList();
    }
}

