/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.dispenser;

import java.util.Optional;
import java.util.function.Consumer;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsTags;
import knightminer.inspirations.recipes.recipe.inventory.VanillaCauldronInventory;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import slimeknights.mantle.util.TileEntityHelper;

public class DispenseCauldronRecipe
extends DefaultDispenseItemBehavior {
    private static final DefaultDispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    private final IDispenseItemBehavior fallback;

    public DispenseCauldronRecipe(IDispenseItemBehavior fallback) {
        this.fallback = fallback;
    }

    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        Optional cauldron;
        BlockPos pos;
        if (!stack.func_77973_b().func_206844_a(InspirationsTags.Items.DISP_CAULDRON_RECIPES)) {
            return this.fallback.dispense(source, stack);
        }
        ServerWorld world = source.func_197524_h();
        BlockState state = world.func_180495_p(pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
        if (!(state.func_177230_c() instanceof CauldronBlock)) {
            return this.fallback.dispense(source, stack);
        }
        DispenserTileEntity dispenser = (DispenserTileEntity)source.func_150835_j();
        Consumer<ItemStack> addItems = item -> {
            if (dispenser.func_146019_a(stack) < 0) {
                DEFAULT.dispense(source, stack);
            }
        };
        if (Config.extendedCauldron.getAsBoolean() && (cauldron = TileEntityHelper.getTile(CauldronTileEntity.class, (IBlockReader)world, (BlockPos)pos)).isPresent()) {
            ItemStack newStack = ((CauldronTileEntity)((Object)cauldron.get())).handleDispenser(stack, addItems);
            if (newStack != null) {
                return newStack;
            }
            return DEFAULT.dispense(source, stack);
        }
        VanillaCauldronInventory inventory = new VanillaCauldronInventory((World)world, pos, state, stack, addItems);
        if (inventory.handleRecipe()) {
            return inventory.getStack();
        }
        return DEFAULT.dispense(source, stack);
    }
}

