/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class EmptyBucketCauldronRecipe
implements ICauldronRecipe {
    private final ResourceLocation id;

    public EmptyBucketCauldronRecipe(ResourceLocation id) {
        this.id = id;
    }

    private static FluidStack drain(ICauldronInventory inv, IFluidHandlerItem handler, IFluidHandler.FluidAction action) {
        if (inv.getLevel() == 0) {
            return handler.drain(1000, action);
        }
        return inv.getContents().get(CauldronContentTypes.FLUID).map(fluid -> handler.drain(new FluidStack(fluid, 1000), action)).orElse(FluidStack.EMPTY);
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        ItemStack stack;
        int level = inv.getLevel();
        if (level == 12) {
            return false;
        }
        if (inv.getStack().func_190916_E() != 1) {
            stack = inv.getStack().func_77946_l();
            stack.func_190920_e(1);
        } else {
            stack = inv.getStack();
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            FluidStack drained = EmptyBucketCauldronRecipe.drain(inv, handler, IFluidHandler.FluidAction.SIMULATE);
            return !drained.isEmpty() && drained.getAmount() == 1000 && !drained.hasTag() && (!inv.isSimple() || drained.getFluid() == Fluids.field_204546_a);
        }).orElse(false);
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inv) {
        ItemStack stack = inv.splitStack(1);
        FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(handler -> {
            FluidStack drained = EmptyBucketCauldronRecipe.drain(inv, handler, IFluidHandler.FluidAction.EXECUTE);
            if (drained.getAmount() >= 1000) {
                Fluid fluid = drained.getFluid();
                inv.setContents(CauldronContentTypes.FLUID.of(fluid));
                inv.setLevel(12);
                inv.setOrGiveStack(handler.getContainer());
                SoundEvent sound = drained.getFluid().getAttributes().getEmptySound(drained);
                if (sound == null) {
                    sound = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
                }
                inv.playSound(sound);
            }
        });
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_EMPTY_BUCKET;
    }
}

