/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.DynamicFinishedRecipe;
import knightminer.inspirations.library.recipe.RecipeSerializer;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronState;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronTransform;
import knightminer.inspirations.library.recipe.cauldron.util.CauldronTemperature;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class PotionFermentCauldronTransform
implements ICauldronTransform {
    private final ResourceLocation id;
    private final int time;

    public PotionFermentCauldronTransform(ResourceLocation id, int time) {
        this.id = id;
        this.time = time;
    }

    public boolean matches(ICauldronState inv, World worldIn) {
        return inv.getLevel() > 0 && inv.getTemperature() == CauldronTemperature.BOILING && inv.getContents().contains(CauldronContentTypes.UNFERMENTED_POTION);
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public ICauldronContents getContentOutput(ICauldronState inv) {
        return inv.getContents().get(CauldronContentTypes.UNFERMENTED_POTION).map(CauldronContentTypes.POTION::of).orElseGet((Supplier<ICauldronContents>)CauldronContentTypes.DEFAULT);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_POTION_FERMENT;
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.field_187621_J;
    }

    public static class FinishedRecipe
    extends DynamicFinishedRecipe {
        private final int time;

        public FinishedRecipe(ResourceLocation id, int time) {
            super(id, RecipeSerializers.CAULDRON_POTION_FERMENT);
            this.time = time;
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.addProperty("time", (Number)this.time);
        }
    }

    public static class Serializer
    extends RecipeSerializer<PotionFermentCauldronTransform> {
        public PotionFermentCauldronTransform read(ResourceLocation id, JsonObject json) {
            int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            return new PotionFermentCauldronTransform(id, time);
        }

        @Nullable
        public PotionFermentCauldronTransform read(ResourceLocation id, PacketBuffer buffer) {
            return new PotionFermentCauldronTransform(id, buffer.func_150792_a());
        }

        public void write(PacketBuffer buffer, PotionFermentCauldronTransform recipe) {
            buffer.func_150787_b(recipe.time);
        }
    }
}

