/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron.contents;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ColorContentType
extends CauldronContentType<Integer> {
    private static final ResourceLocation TEXTURE_NAME = Inspirations.getResource("color");
    private static final String TRANSLATION_KEY = Util.func_200697_a((String)"cauldron_contents", (ResourceLocation)Inspirations.getResource("color"));

    public static String getColorString(int color) {
        return String.format("%06X", color);
    }

    public static ITextComponent getColorTooltip(int color) {
        return new TranslationTextComponent("item.color", new Object[]{"#" + ColorContentType.getColorString(color)}).func_240699_a_(TextFormatting.GRAY);
    }

    @Override
    public String getKey() {
        return "color";
    }

    @Override
    public String getName(Integer value) {
        return ColorContentType.getColorString(value);
    }

    @Nullable
    private Integer getValue(String str) {
        try {
            return Integer.parseInt(str, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Integer getValue(JsonElement element, String key) {
        String text = JSONUtils.func_151206_a((JsonElement)element, (String)key);
        Integer value = this.getValue(text);
        if (value != null) {
            return value;
        }
        throw new JsonSyntaxException("Invalid color value '" + text + "'");
    }

    @Override
    @Nullable
    public Integer read(CompoundNBT tag) {
        if (tag.func_150297_b(this.getKey(), 8)) {
            return this.getValue(tag.func_74779_i(this.getKey()));
        }
        return null;
    }

    @Override
    public Integer read(PacketBuffer buffer) {
        return buffer.readInt();
    }

    @Override
    public void write(Integer color, PacketBuffer buffer) {
        buffer.writeInt(color.intValue());
    }

    @Override
    public ResourceLocation getTexture(Integer value) {
        return TEXTURE_NAME;
    }

    @Override
    public int getColor(Integer value) {
        return value;
    }

    @Override
    public ITextComponent getDisplayName(Integer value) {
        return new TranslationTextComponent(TRANSLATION_KEY);
    }

    @Override
    public void addInformation(Integer value, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        if (tooltipFlag.func_194127_a()) {
            tooltip.add(ColorContentType.getColorTooltip(value));
        }
    }
}

