/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.inventory;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.util.CauldronTemperature;
import knightminer.inspirations.recipes.recipe.inventory.CauldronItemInventory;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileCauldronInventory
extends CauldronItemInventory {
    private final CauldronTileEntity tile;
    @Nullable
    private ICauldronContents newContents = null;
    private int newLevel = -1;
    private boolean silent = false;

    public TileCauldronInventory(CauldronTileEntity tile) {
        this.tile = tile;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public void playSound(SoundEvent sound) {
        World world;
        if (!this.silent && (world = this.tile.func_145831_w()) != null) {
            world.func_184133_a(null, this.tile.func_174877_v(), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void clearCache() {
        this.newLevel = -1;
        this.newContents = null;
        this.silent = false;
    }

    public void setItemContext(ItemStack stack, @Nullable Consumer<ItemStack> itemSetter, Consumer<ItemStack> itemAdder) {
        this.stack = stack;
        this.itemSetter = itemSetter == null ? EMPTY_CONSUMER : itemSetter;
        this.itemAdder = itemAdder;
        this.clearCache();
    }

    public void setItemHandlerContext(Consumer<ItemStack> itemAdder, boolean silent) {
        this.setItemContext(ItemStack.field_190927_a, null, itemAdder);
        this.silent = silent;
    }

    public void clearContext() {
        this.stack = ItemStack.field_190927_a;
        this.itemSetter = EMPTY_CONSUMER;
        this.itemAdder = EMPTY_CONSUMER;
        this.clearCache();
    }

    @Override
    public int getLevel() {
        if (this.newLevel != -1) {
            return this.newLevel;
        }
        return this.tile.getLevel();
    }

    @Override
    public void setLevel(int level) {
        this.newLevel = MathHelper.func_76125_a((int)level, (int)0, (int)12);
    }

    @Override
    public ICauldronContents getContents() {
        if (this.newContents != null) {
            return this.newContents;
        }
        return this.tile.getContents();
    }

    @Override
    public void setContents(ICauldronContents contents) {
        this.newContents = contents;
    }

    @Override
    public CauldronTemperature getTemperature() {
        return this.tile.getTemperature();
    }
}

