/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.tileentity;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.CauldronStateUpdatePacket;
import knightminer.inspirations.common.network.CauldronTransformUpatePacket;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.library.InspirationsTags;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.RecipeTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronTransform;
import knightminer.inspirations.library.recipe.cauldron.util.CauldronTemperature;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.block.EnhancedCauldronBlock;
import knightminer.inspirations.recipes.recipe.inventory.CauldronItemInventory;
import knightminer.inspirations.recipes.recipe.inventory.TileCauldronInventory;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.tileentity.MantleTileEntity;

public class CauldronTileEntity
extends MantleTileEntity
implements ITickableTileEntity {
    private static final DamageSource DAMAGE_BOIL = new DamageSource(Inspirations.prefix("boiling")).func_76348_h();
    public static final ModelProperty<ResourceLocation> TEXTURE = new ModelProperty();
    public static final ModelProperty<Boolean> FROSTED = new ModelProperty();
    public static final ModelProperty<Integer> OFFSET = new ModelProperty();
    private final IModelData data = new ModelDataMap.Builder().withInitial(TEXTURE, (Object)((ICauldronContents)CauldronContentTypes.DEFAULT.get()).getTextureName()).withInitial(FROSTED, (Object)false).withInitial(OFFSET, (Object)0).build();
    private final TileCauldronInventory craftingInventory = new TileCauldronInventory(this);
    private ICauldronContents contents = (ICauldronContents)CauldronContentTypes.DEFAULT.get();
    private int levelOffset;
    private EnhancedCauldronBlock cauldronBlock;
    private ICauldronRecipe lastRecipe;
    private Boolean isBoiling;
    private Boolean isFreezing;
    private CauldronTemperature temperature;
    private int timer;
    private ResourceLocation currentTransformName;
    private ICauldronTransform currentTransform;
    private ICauldronTransform lastTransform;
    private boolean updateTransform;
    private static final String TAG_CAULDRON_CRAFTED = "cauldron_crafted";
    private static final String TAG_CAULDRON_COOLDOWN = "cauldron_cooldown";
    private static final String TAG_CONTENTS = "contents";
    private static final String TAG_LEVEL_OFFSET = "level_offset";
    private static final String TAG_TRANSFORM = "transform";
    private static final String TAG_TIMER = "timer";

    public CauldronTileEntity() {
        this(InspirationsRecipes.cauldron);
    }

    public CauldronTileEntity(EnhancedCauldronBlock block) {
        this(InspirationsRecipes.tileCauldron, block);
    }

    protected CauldronTileEntity(TileEntityType<?> type, EnhancedCauldronBlock block) {
        super(type);
        this.data.setData(TEXTURE, (Object)this.contents.getTextureName());
        this.cauldronBlock = block;
    }

    public IModelData getModelData() {
        this.getTemperature(false);
        return this.data;
    }

    public ICauldronContents getContents() {
        return this.contents;
    }

    public int getLevel() {
        return this.cauldronBlock.getLevel(this.func_195044_w()) * 4 + this.levelOffset;
    }

    public boolean canMimicVanilla() {
        return this.levelOffset >= 0 && this.contents.isSimple();
    }

    private void contentsChanged() {
        this.updateTransform = true;
    }

    public void updateStateAndBlock(@Nullable ICauldronContents contents, int level) {
        int stateLevel = this.updateStateFromLevels(contents, level);
        if (this.field_145850_b != null) {
            this.cauldronBlock.func_176590_a(this.field_145850_b, this.field_174879_c, this.func_195044_w(), stateLevel);
        }
    }

    protected int updateStateFromLevels(@Nullable ICauldronContents contents, int level) {
        int stateLevel;
        int newOffset;
        if (level == 0) {
            newOffset = 0;
            stateLevel = 0;
        } else if (level < 4) {
            newOffset = level - 4;
            stateLevel = 1;
        } else {
            newOffset = level % 4;
            stateLevel = level / 4;
        }
        this.updateState(contents, newOffset);
        return stateLevel;
    }

    protected void updateState(@Nullable ICauldronContents contents, int levelOffset) {
        if (contents == null || this.contents.equals(contents)) {
            contents = null;
        } else {
            this.contents = contents;
        }
        if (levelOffset != this.levelOffset || contents != null) {
            this.levelOffset = levelOffset;
            InspirationsNetwork.sendToClients(this.field_145850_b, this.field_174879_c, (ISimplePacket)new CauldronStateUpdatePacket(this.field_174879_c, contents, levelOffset));
            this.contentsChanged();
        }
    }

    public boolean updateStateAndData(@Nullable ICauldronContents contents, int levelOffset) {
        boolean updated = false;
        if (levelOffset != this.levelOffset) {
            this.levelOffset = levelOffset;
            this.data.setData(OFFSET, (Object)levelOffset);
            updated = true;
        }
        if (contents != null && !this.contents.equals(contents)) {
            this.contents = contents;
            this.data.setData(TEXTURE, (Object)contents.getTextureName());
            updated = true;
        }
        return updated;
    }

    public static boolean isCauldronFire(BlockState state) {
        if (state.func_177230_c().func_203417_a(InspirationsTags.Blocks.CAULDRON_FIRE)) {
            return !state.func_235901_b_((Property)BlockStateProperties.field_208190_q) || (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false;
        }
        return false;
    }

    private static boolean isDirectionFreezing(World world, BlockPos pos, Direction direction) {
        return world.func_180495_p(pos.func_177972_a(direction)).func_235714_a_(InspirationsTags.Blocks.CAULDRON_ICE) && world.func_180495_p(pos.func_177972_a(direction.func_176734_d())).func_235714_a_(InspirationsTags.Blocks.CAULDRON_ICE);
    }

    public static boolean isFreezing(World world, BlockPos pos) {
        return CauldronTileEntity.isDirectionFreezing(world, pos, Direction.NORTH) || CauldronTileEntity.isDirectionFreezing(world, pos, Direction.WEST);
    }

    public static CauldronTemperature calcTemperature(IWorld world, BlockPos pos, boolean boiling, boolean freezing) {
        if (boiling) {
            return freezing ? CauldronTemperature.NORMAL : CauldronTemperature.BOILING;
        }
        if (freezing) {
            return CauldronTemperature.FREEZING;
        }
        if (world.func_230315_m_().func_236040_e_()) {
            return CauldronTemperature.BOILING;
        }
        if (world.func_226691_t_(pos).func_225486_c(pos) < 0.15f) {
            return CauldronTemperature.FREEZING;
        }
        return CauldronTemperature.NORMAL;
    }

    private CauldronTemperature getTemperature(boolean updateModelData) {
        if (this.field_145850_b == null) {
            return CauldronTemperature.NORMAL;
        }
        if (this.temperature == null) {
            if (this.isBoiling == null) {
                this.isBoiling = CauldronTileEntity.isCauldronFire(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
            }
            if (this.isFreezing == null) {
                this.isFreezing = CauldronTileEntity.isFreezing(this.field_145850_b, this.field_174879_c);
            }
            this.temperature = CauldronTileEntity.calcTemperature((IWorld)this.field_145850_b, this.field_174879_c, this.isBoiling, this.isFreezing);
            this.data.setData(FROSTED, (Object)(this.temperature == CauldronTemperature.FREEZING ? 1 : 0));
            if (updateModelData) {
                this.requestModelDataUpdate();
            }
        }
        return this.temperature;
    }

    public CauldronTemperature getTemperature() {
        return this.getTemperature(true);
    }

    private static Direction getDirection(BlockPos offset) {
        for (Direction direction : Direction.values()) {
            if (!direction.func_176730_m().equals((Object)offset)) continue;
            return direction;
        }
        return Direction.UP;
    }

    public void neighborChanged(BlockPos neighbor) {
        Direction direction = CauldronTileEntity.getDirection(neighbor.func_177973_b((Vector3i)this.field_174879_c));
        CauldronTemperature oldTemperature = this.temperature;
        if (direction == Direction.DOWN) {
            this.isBoiling = null;
            this.temperature = null;
            this.contentsChanged();
        } else if (direction.func_176740_k() != Direction.Axis.Y) {
            this.isFreezing = null;
            this.temperature = null;
            this.contentsChanged();
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.temperature = this.getTemperature();
            if (this.temperature != oldTemperature) {
                Util.notifyClientUpdate((TileEntity)this);
            }
        }
    }

    @Nullable
    public ICauldronRecipe findRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        if (this.lastRecipe != null && this.lastRecipe.func_77569_a((IInventory)this.craftingInventory, this.field_145850_b)) {
            return this.lastRecipe;
        }
        ICauldronRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeTypes.CAULDRON, (IInventory)this.craftingInventory, this.field_145850_b).orElse(null);
        if (recipe != null) {
            this.lastRecipe = recipe;
            return recipe;
        }
        return null;
    }

    private boolean handleRecipe(ItemStack stack, @Nullable Consumer<ItemStack> itemSetter, Consumer<ItemStack> itemAdder) {
        if (this.field_145850_b == null) {
            return false;
        }
        this.craftingInventory.setItemContext(stack, itemSetter, itemAdder);
        ICauldronRecipe recipe = this.findRecipe();
        boolean success = false;
        if (recipe != null) {
            success = true;
            if (!this.field_145850_b.field_72995_K) {
                recipe.handleRecipe(this.craftingInventory);
            }
        }
        return success;
    }

    public boolean interact(PlayerEntity player, Hand hand) {
        if (this.field_145850_b == null) {
            return false;
        }
        boolean success = this.handleRecipe(player.func_184586_b(hand), stack -> player.func_184611_a(hand, stack), CauldronItemInventory.getPlayerAdder(player));
        if (success) {
            this.updateStateAndBlock(this.craftingInventory.getContents(), this.craftingInventory.getLevel());
        }
        this.craftingInventory.clearContext();
        return success;
    }

    @Nullable
    public ItemStack handleDispenser(ItemStack stack, Consumer<ItemStack> itemAdder) {
        if (this.field_145850_b == null) {
            return null;
        }
        ItemStack result = null;
        if (this.handleRecipe(stack, null, itemAdder)) {
            this.updateStateAndBlock(this.craftingInventory.getContents(), this.craftingInventory.getLevel());
            result = this.craftingInventory.getStack();
        }
        this.craftingInventory.clearContext();
        return result;
    }

    public int onEntityCollide(Entity entity, int level, BlockState currentState) {
        if (this.field_145850_b == null) {
            return level;
        }
        if (entity instanceof ItemEntity && Config.cauldronRecipes.getAsBoolean()) {
            ItemEntity entityItem = (ItemEntity)entity;
            CompoundNBT entityTags = entity.getPersistentData();
            if (entityTags.func_74767_n(TAG_CAULDRON_CRAFTED)) {
                return level;
            }
            int cooldown = entityTags.func_74762_e(TAG_CAULDRON_COOLDOWN);
            if (cooldown > 0) {
                entityTags.func_74768_a(TAG_CAULDRON_COOLDOWN, cooldown - 1);
                return level;
            }
            boolean success = this.handleRecipe(entityItem.func_92059_d(), stack -> entityItem.func_92058_a(stack.func_77946_l()), stack -> {
                ItemEntity newItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
                newItem.getPersistentData().func_74757_a(TAG_CAULDRON_CRAFTED, true);
                newItem.func_174869_p();
                this.field_145850_b.func_217376_c((Entity)newItem);
            });
            if (success) {
                int matches;
                for (matches = 0; this.lastRecipe.func_77569_a((IInventory)this.craftingInventory, this.field_145850_b) && matches < 64; ++matches) {
                    this.lastRecipe.handleRecipe(this.craftingInventory);
                }
                if (matches == 64) {
                    Inspirations.log.warn("Recipe '{}' matched too many times in a single tick. Either the level or the state should change to make it no longer match.", (Object)this.lastRecipe.func_199560_c());
                }
            }
            if (entityItem.func_92059_d().func_190926_b()) {
                entityItem.func_70106_y();
            } else if (success) {
                entityTags.func_74757_a(TAG_CAULDRON_CRAFTED, true);
            } else {
                entityTags.func_74768_a(TAG_CAULDRON_COOLDOWN, 60);
            }
            int stateLevel = this.updateStateFromLevels(this.craftingInventory.getContents(), this.craftingInventory.getLevel());
            this.craftingInventory.clearContext();
            return stateLevel;
        }
        if (level > 0) {
            Optional<Fluid> fluidType = this.contents.get(CauldronContentTypes.FLUID);
            if (fluidType.isPresent()) {
                Fluid fluid = fluidType.get();
                if (FluidTags.field_206959_a.func_230235_a_((Object)fluid)) {
                    if (entity.func_70027_ad()) {
                        entity.func_70066_B();
                        --level;
                    }
                } else if (fluid.getAttributes().getTemperature() > 450 && !entity.func_230279_az_()) {
                    entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                    entity.func_70015_d(15);
                    return level;
                }
            } else {
                Optional<Potion> potionType = this.contents.get(CauldronContentTypes.POTION);
                if (potionType.isPresent() && entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    List effects = potionType.get().func_185170_a();
                    if (effects.stream().anyMatch(effect -> !living.func_70644_a(effect.func_188419_a()))) {
                        for (EffectInstance effect2 : effects) {
                            if (effect2.func_188419_a().func_76403_b()) {
                                effect2.func_188419_a().func_180793_a(null, null, living, effect2.func_76458_c(), 1.0);
                                continue;
                            }
                            living.func_195064_c(new EffectInstance(effect2));
                        }
                        --level;
                    }
                    return level;
                }
            }
            if (this.getTemperature() == CauldronTemperature.BOILING) {
                entity.func_70097_a(DAMAGE_BOIL, 2.0f);
            }
        }
        return level;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.contentsChanged();
    }

    public void updateTransform() {
        if (this.currentTransformName != null) {
            return;
        }
        if (this.field_145850_b == null || this.currentTransform != null && this.currentTransform.func_77569_a((IInventory)this.craftingInventory, this.field_145850_b)) {
            return;
        }
        this.timer = 0;
        ICauldronTransform transform = null;
        if (this.getLevel() > 0) {
            if (this.lastTransform != null && this.lastTransform.func_77569_a((IInventory)this.craftingInventory, this.field_145850_b)) {
                transform = this.lastTransform;
            } else {
                Optional newTransform = this.field_145850_b.func_199532_z().func_215371_a(RecipeTypes.CAULDRON_TRANSFORM, (IInventory)this.craftingInventory, this.field_145850_b);
                if (newTransform.isPresent()) {
                    transform = this.lastTransform = (ICauldronTransform)newTransform.get();
                }
            }
        }
        if (this.currentTransform != transform) {
            this.currentTransform = transform;
            InspirationsNetwork.sendToClients(this.field_145850_b, this.field_174879_c, (ISimplePacket)new CauldronTransformUpatePacket(this.field_174879_c, transform));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.updateTransform && !this.field_145850_b.field_72995_K) {
            this.updateTransform();
            this.updateTransform = false;
        }
        if (this.currentTransform == null) {
            return;
        }
        ++this.timer;
        if (!this.field_145850_b.field_72995_K && this.timer >= this.currentTransform.getTime()) {
            this.timer = 0;
            SoundEvent sound = this.currentTransform.getSound();
            this.field_145850_b.func_184133_a(null, this.field_174879_c, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.updateState(this.currentTransform.getContentOutput(this.craftingInventory), this.levelOffset);
        }
    }

    public void setTransformRecipe(@Nullable ICauldronTransform recipe) {
        this.currentTransform = recipe;
        this.timer = 0;
    }

    public int getTransformParticles() {
        if (this.currentTransform == null) {
            return 0;
        }
        return this.timer * 5 / this.currentTransform.getTime();
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        if (this.currentTransformName != null) {
            this.loadTransform(world, this.currentTransformName);
            this.currentTransformName = null;
        }
    }

    private void loadTransform(World world, ResourceLocation name) {
        RecipeHelper.getRecipe((RecipeManager)world.func_199532_z(), (ResourceLocation)name, ICauldronTransform.class).ifPresent(recipe -> {
            this.currentTransform = recipe;
        });
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void writeSynced(CompoundNBT tags) {
        super.writeSynced(tags);
        tags.func_218657_a(TAG_CONTENTS, (INBT)this.getContents().toNBT());
        if (this.currentTransform != null) {
            tags.func_74778_a(TAG_TRANSFORM, this.currentTransform.func_199560_c().toString());
        } else if (this.currentTransformName != null) {
            tags.func_74778_a(TAG_TRANSFORM, this.currentTransformName.toString());
        }
        tags.func_74768_a(TAG_TIMER, this.timer);
        tags.func_74768_a(TAG_LEVEL_OFFSET, this.levelOffset);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        Block block = state.func_177230_c();
        if (block instanceof EnhancedCauldronBlock) {
            this.cauldronBlock = (EnhancedCauldronBlock)block;
        }
        if (tags.func_150297_b(TAG_TRANSFORM, 8)) {
            ResourceLocation name = new ResourceLocation(tags.func_74779_i(TAG_TRANSFORM));
            if (this.field_145850_b != null) {
                this.loadTransform(this.field_145850_b, name);
            } else {
                this.currentTransformName = name;
            }
        }
        this.updateStateAndData(CauldronContentTypes.read(tags.func_74775_l(TAG_CONTENTS)), tags.func_74762_e(TAG_LEVEL_OFFSET));
        this.timer = tags.func_74762_e(TAG_TIMER);
    }
}

