/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.tileentity.capability;

import java.util.function.Consumer;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.recipes.recipe.inventory.TileCauldronInventory;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CauldronItemHandler
implements IItemHandler {
    private final CauldronTileEntity te;
    private final TileCauldronInventory inventory;
    private ICauldronRecipe currentRecipe;
    private ItemStack stack;
    private boolean hasSideEffects = false;
    private final Consumer<ItemStack> sideEffects = stack -> {
        this.hasSideEffects = true;
    };

    public CauldronItemHandler(CauldronTileEntity te, TileCauldronInventory inventory) {
        this.te = te;
        this.inventory = inventory;
    }

    private ItemStack handleRecipe(ICauldronRecipe recipe, boolean execute) {
        this.hasSideEffects = false;
        this.inventory.setItemHandlerContext(this.sideEffects, execute);
        recipe.handleRecipe(this.inventory);
        if (this.hasSideEffects) {
            this.stack = ItemStack.field_190927_a;
            this.currentRecipe = null;
            return this.stack;
        }
        this.currentRecipe = recipe;
        ItemStack result = this.stack = this.inventory.getStack();
        if (execute && !this.stack.func_190926_b()) {
            result = this.stack.func_77946_l();
            this.te.updateStateAndBlock(this.inventory.getContents(), this.inventory.getLevel());
        }
        this.inventory.clearContext();
        return result;
    }

    private ItemStack getResult() {
        if (this.stack == null) {
            ICauldronRecipe recipe = this.te.findRecipe();
            if (recipe != null) {
                this.handleRecipe(recipe, false);
            } else {
                this.stack = ItemStack.field_190927_a;
            }
        }
        return this.stack;
    }

    public void clearCache() {
        this.stack = null;
        this.currentRecipe = null;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getResult();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        World world;
        if (simulate) {
            ItemStack result = this.getResult();
            if (result.func_190916_E() > amount) {
                return ItemStack.field_190927_a;
            }
            return result;
        }
        ICauldronRecipe recipe = this.currentRecipe;
        boolean needsValidation = true;
        if (recipe == null && this.stack == null) {
            recipe = this.te.findRecipe();
            needsValidation = false;
        }
        if (recipe == null) {
            this.stack = ItemStack.field_190927_a;
            return this.stack;
        }
        if (this.stack.func_190916_E() > amount) {
            return ItemStack.field_190927_a;
        }
        if (needsValidation && ((world = this.te.func_145831_w()) == null || !this.currentRecipe.func_77569_a((IInventory)this.inventory, world))) {
            this.clearCache();
            Inspirations.log.error("Attempted to extract items from a recipe that does not match the cauldron.");
            return ItemStack.field_190927_a;
        }
        return this.handleRecipe(recipe, true);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }
}

