/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import java.util.Random;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.tools.InspirationsTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.VineBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.ThornsEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolsEvents {
    @SubscribeEvent
    public static void lockAndUnlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isLock;
        if (!((Boolean)Config.enableLock.get()).booleanValue()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        boolean isKey = stack.func_77973_b() == InspirationsTools.key;
        boolean bl = isLock = stack.func_77973_b() == InspirationsTools.lock;
        if (!isKey && !isLock) {
            return;
        }
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof LockableTileEntity) {
            LockableTileEntity lockable = (LockableTileEntity)te;
            LockCode heldCode = new LockCode(stack.func_200301_q().func_150261_e());
            if (isLock) {
                if (lockable.field_174901_a != LockCode.field_180162_a) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(Inspirations.prefix("lock.fail.locked")), true);
                } else if (!stack.func_82837_s()) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(Inspirations.prefix("lock.fail.blank")), true);
                } else {
                    lockable.field_174901_a = heldCode;
                    lockable.func_70296_d();
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(Inspirations.prefix("lock.success")), true);
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            } else if (player.func_213453_ef()) {
                if (lockable.field_174901_a != LockCode.field_180162_a) {
                    if (lockable.field_174901_a.func_219964_a(stack)) {
                        LockCode code = lockable.field_174901_a;
                        lockable.field_174901_a = LockCode.field_180162_a;
                        lockable.func_70296_d();
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)InspirationsTools.lock).func_200302_a((ITextComponent)new StringTextComponent(code.field_180161_b)));
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(Inspirations.prefix("unlock.success")), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(Inspirations.prefix("unlock.fail.no_match")), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(Inspirations.prefix("unlock.fail.unlocked")), true);
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void vineBreakEvent(BlockEvent.BreakEvent event) {
        if (!((Boolean)Config.harvestHangingVines.get()).booleanValue()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getWorld().func_201670_d() || !(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        PlayerEntity player = event.getPlayer();
        if (player.func_184812_l_()) {
            return;
        }
        Block block = event.getState().func_177230_c();
        if (!(block instanceof VineBlock)) {
            return;
        }
        ItemStack shears = player.func_184614_ca();
        Item item = shears.func_77973_b();
        if (!(item instanceof ShearsItem) && !item.getToolTypes(shears).contains(InspirationsRegistry.SHEAR_TYPE)) {
            return;
        }
        BlockPos pos = event.getPos().func_177977_b();
        VineBlock vine = (VineBlock)block;
        BlockState state = world.func_180495_p(pos);
        int count = 0;
        while (state.func_177230_c() == block && vine.isShearable(shears, (World)world, pos) && !ToolsEvents.vineCanStay((World)world, state, pos)) {
            ++count;
            for (ItemStack stack : state.func_215693_a(new LootContext.Builder(world).func_216015_a(LootParameters.field_216289_i, (Object)shears).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216281_a, (Object)player))) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            pos = pos.func_177977_b();
            state = world.func_180495_p(pos);
        }
        for (int i = 0; i < count; ++i) {
            pos = pos.func_177984_a();
            world.func_217377_a(pos, false);
        }
    }

    private static boolean vineCanStay(World world, BlockState state, BlockPos pos) {
        for (Direction side : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.func_177229_b((Property)VineBlock.func_176267_a((Direction)side))).booleanValue() || !VineBlock.func_196542_b((IBlockReader)world, (BlockPos)pos.func_177972_a(side), (Direction)side)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    static void onShieldHit(LivingAttackEvent event) {
        if (!((Boolean)Config.moreShieldEnchantments.get()).booleanValue()) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        if (target.field_70170_p.field_72995_K || !target.func_184585_cz()) {
            return;
        }
        ItemStack stack = target.func_184607_cu();
        int thorns = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack);
        int fire = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
        int knockback = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack);
        if (thorns == 0 && fire == 0 && knockback == 0) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.func_76364_f();
        if (attacker != null && !target.func_180431_b(source) && target.func_184583_d(source)) {
            if (thorns > 0 && ThornsEnchantment.func_92094_a((int)thorns, (Random)target.field_70170_p.field_73012_v)) {
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)target), (float)ThornsEnchantment.func_92095_b((int)thorns, (Random)target.field_70170_p.field_73012_v));
                stack.func_222118_a(1, target, play -> play.func_213334_d(target.func_184600_cs()));
            }
            if (fire > 0) {
                attacker.func_70015_d(fire * 4);
            }
            if (knockback > 0) {
                if (attacker instanceof LivingEntity) {
                    ((LivingEntity)attacker).func_233627_a_((float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(target.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(target.field_70177_z * ((float)Math.PI / 180)))));
                    if (attacker instanceof ServerPlayerEntity) {
                        InspirationsNetwork.sendPacket(attacker, new SEntityVelocityPacket(attacker));
                    }
                } else {
                    attacker.func_70024_g((double)(-MathHelper.func_76126_a((float)(target.field_70177_z * ((float)Math.PI / 180))) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(target.field_70177_z * ((float)Math.PI / 180))) * (float)knockback * 0.5f));
                }
            }
        }
    }
}

