/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.network.DimensionCompassPositionPacket;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.tools.capability.IDimensionCompass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class DimensionCompass
implements ICapabilitySerializable<CompoundNBT>,
IDimensionCompass {
    public static final ResourceLocation KEY = Inspirations.getResource("dimension_compass");
    @CapabilityInject(value=IDimensionCompass.class)
    public static Capability<IDimensionCompass> CAPABILITY = null;
    private final LazyOptional<IDimensionCompass> capabilityInstance = LazyOptional.of(() -> this);
    private BlockPos enteredPosition;

    public static void register() {
        CapabilityManager.INSTANCE.register(IDimensionCompass.class, (Capability.IStorage)new Capability.IStorage<IDimensionCompass>(){

            @Nullable
            public INBT writeNBT(Capability<IDimensionCompass> capability, IDimensionCompass instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<IDimensionCompass> capability, IDimensionCompass instance, Direction side, INBT nbt) {
            }
        }, DimensionCompass::new);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, DimensionCompass::attachCapability);
        MinecraftForge.EVENT_BUS.addListener(DimensionCompass::dimensionChange);
        MinecraftForge.EVENT_BUS.addListener(DimensionCompass::playerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, DimensionCompass::dimensionTravel);
    }

    @Override
    @Nullable
    public BlockPos getEnteredPosition() {
        return this.enteredPosition;
    }

    @Override
    public void setEnteredPosition(@Nullable BlockPos pos) {
        this.enteredPosition = pos;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CAPABILITY) {
            return this.capabilityInstance.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        BlockPos pos = this.getEnteredPosition();
        if (pos == null) {
            return new CompoundNBT();
        }
        return NBTUtil.func_186859_a((BlockPos)pos);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("X", 99) && nbt.func_150297_b("Y", 99) && nbt.func_150297_b("Z", 99)) {
            this.setEnteredPosition(NBTUtil.func_186861_c((CompoundNBT)nbt));
        } else {
            this.setEnteredPosition(null);
        }
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(KEY, (ICapabilityProvider)new DimensionCompass());
        }
    }

    private static void sync(PlayerEntity player, @Nullable BlockPos pos) {
        if (player instanceof ServerPlayerEntity) {
            InspirationsNetwork.INSTANCE.sendTo(new DimensionCompassPositionPacket(pos), (ServerPlayerEntity)player);
        }
    }

    private static void dimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockPos pos = player.func_233580_cy_();
        DimensionCompass.sync(player, pos);
        player.getCapability(CAPABILITY).ifPresent(compass -> compass.setEnteredPosition(pos));
    }

    private static void dimensionTravel(EntityTravelToDimensionEvent event) {
        Entity entity;
        if (event.getDimension() == World.field_234918_g_ && (entity = event.getEntity()).func_130014_f_().func_234923_W_() == World.field_234920_i_ && entity instanceof ServerPlayerEntity) {
            entity.getCapability(CAPABILITY).ifPresent(compass -> compass.setEnteredPosition(null));
            InspirationsNetwork.INSTANCE.sendTo(new DimensionCompassPositionPacket((BlockPos)null), (ServerPlayerEntity)entity);
        }
    }

    private static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        player.getCapability(CAPABILITY).ifPresent(compass -> {
            BlockPos pos = compass.getEnteredPosition();
            if (pos != null) {
                DimensionCompass.sync(player, pos);
            }
        });
    }
}

