/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.client;

import java.util.Optional;
import javax.annotation.Nullable;
import knightminer.inspirations.tools.capability.DimensionCompass;
import knightminer.inspirations.tools.capability.IDimensionCompass;
import knightminer.inspirations.tools.client.Angle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CompassItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class DimensionCompassPropertyGetter
implements IItemPropertyGetter {
    private final Angle positionWobble = new Angle();
    private final Angle randomRotation = new Angle();

    public float call(ItemStack stack, @Nullable ClientWorld clientWorld, @Nullable LivingEntity living) {
        LivingEntity entity;
        Object object = entity = living != null ? living : stack.func_234694_A_();
        if (entity == null) {
            return 0.0f;
        }
        ClientWorld world = clientWorld;
        if (world == null) {
            if (entity.field_70170_p == null) {
                return 0.0f;
            }
            world = entity.field_70170_p;
        }
        BlockPos pos = CompassItem.func_234670_d_((ItemStack)stack) ? DimensionCompassPropertyGetter.getLodestonePosition((World)world, stack.func_196082_o()) : DimensionCompassPropertyGetter.getDimensionEntered((Entity)entity);
        long time = world.func_82737_E();
        Vector3d entityPos = entity.func_213303_ch();
        if (pos != null && entityPos.func_186679_c((double)pos.func_177958_n() + 0.5, entityPos.func_82617_b(), (double)pos.func_177952_p() + 0.5) >= (double)1.0E-5f) {
            double wobbleRotation;
            boolean isPlayer = living instanceof PlayerEntity && ((PlayerEntity)living).func_175144_cb();
            double holderAngle = 0.0;
            if (isPlayer) {
                holderAngle = living.field_70177_z;
            } else if (entity instanceof ItemFrameEntity) {
                holderAngle = Angle.getFrameRotation((ItemFrameEntity)entity);
            } else if (entity instanceof ItemEntity) {
                holderAngle = 180.0f - ((ItemEntity)entity).func_234272_a_(0.5f) / ((float)Math.PI * 2) * 360.0f;
            } else if (living != null) {
                holderAngle = living.field_70761_aq;
            }
            holderAngle = MathHelper.func_191273_b((double)(holderAngle / 360.0), (double)1.0);
            double exactRotation = DimensionCompassPropertyGetter.getAngleToPosition(Vector3d.func_237489_a_((Vector3i)pos), (Entity)entity) / 6.2831854820251465;
            if (isPlayer) {
                if (this.positionWobble.shouldUpdate(time)) {
                    this.positionWobble.wobble(time, 0.5 - (holderAngle - 0.25));
                }
                wobbleRotation = exactRotation + this.positionWobble.getRotation();
            } else {
                wobbleRotation = 0.5 - (holderAngle - 0.25 - exactRotation);
            }
            return MathHelper.func_188207_b((float)((float)wobbleRotation), (float)1.0f);
        }
        if (this.randomRotation.shouldUpdate(time)) {
            this.randomRotation.wobble(time, Math.random());
        }
        double wobbleRotation = this.randomRotation.getRotation() + (double)((float)stack.hashCode() / 2.1474836E9f);
        return MathHelper.func_188207_b((float)((float)wobbleRotation), (float)1.0f);
    }

    @Nullable
    private static BlockPos getDimensionEntered(Entity entity) {
        return entity.getCapability(DimensionCompass.CAPABILITY).resolve().map(IDimensionCompass::getEnteredPosition).orElse(null);
    }

    @Nullable
    private static BlockPos getLodestonePosition(World world, CompoundNBT nbt) {
        Optional optional;
        boolean hasPos = nbt.func_74764_b("LodestonePos");
        boolean hasDim = nbt.func_74764_b("LodestoneDimension");
        if (hasPos && hasDim && (optional = CompassItem.func_234667_a_((CompoundNBT)nbt)).isPresent()) {
            RegistryKey storedDimension = (RegistryKey)optional.get();
            RegistryKey currentDimension = world.func_234923_W_();
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("LodestonePos"));
            if (storedDimension != currentDimension) {
                if (storedDimension == World.field_234919_h_) {
                    return new BlockPos(pos.func_177958_n() * 8, pos.func_177956_o(), pos.func_177952_p() * 8);
                }
                if (currentDimension == World.field_234919_h_) {
                    return new BlockPos(Math.round((float)pos.func_177958_n() / 8.0f), pos.func_177956_o(), Math.round((float)pos.func_177952_p() / 8.0f));
                }
            }
            return pos;
        }
        return null;
    }

    private static double getAngleToPosition(Vector3d target, Entity entity) {
        return Math.atan2(target.func_82616_c() - entity.func_226281_cx_(), target.func_82615_a() - entity.func_226277_ct_());
    }
}

