/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.tweaks.block.BlockCropBlock;
import knightminer.inspirations.tweaks.block.CactusCropBlock;
import knightminer.inspirations.tweaks.block.DryHopperBlock;
import knightminer.inspirations.tweaks.block.FittedCarpetBlock;
import knightminer.inspirations.tweaks.block.FlatCarpetBlock;
import knightminer.inspirations.tweaks.block.SugarCaneCropBlock;
import knightminer.inspirations.tweaks.block.WetHopperBlock;
import knightminer.inspirations.tweaks.datagen.TweaksRecipeProvider;
import knightminer.inspirations.tweaks.item.SeedItem;
import knightminer.inspirations.tweaks.recipe.NormalBrewingRecipe;
import knightminer.inspirations.tweaks.util.SmoothGrowthListener;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsTweaks
extends ModuleBase {
    public static final String pulseID = "InspirationsTweaks";
    public static BlockCropBlock cactus;
    public static BlockCropBlock sugarCane;
    public static HopperBlock wetHopper;
    public static HopperBlock dryHopper;
    public static EnumObject<DyeColor, FittedCarpetBlock> fitCarpets;
    public static EnumObject<DyeColor, FlatCarpetBlock> flatCarpets;
    public static Item sugarCaneSeeds;
    public static Item cactusSeeds;
    public static Item heartbeet;
    private static final IDispenseItemBehavior DEFAULT;

    @SubscribeEvent
    void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistryAdapter registry = new BlockRegistryAdapter(event.getRegistry());
        IForgeRegistry r = event.getRegistry();
        boolean replaceVanilla = Config.enableFittedCarpets.getAsBoolean();
        EnumObject.Builder flatBuilder = new EnumObject.Builder(DyeColor.class);
        EnumObject.Builder fittedBuilder = new EnumObject.Builder(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            Block original = (Block)InspirationsShared.VANILLA_CARPETS.get((Enum)color);
            AbstractBlock.Properties props = AbstractBlock.Properties.func_200950_a((AbstractBlock)original);
            if (replaceVanilla) {
                flatBuilder.putDelegate((Enum)color, ((FlatCarpetBlock)registry.register((IForgeRegistryEntry)new FlatCarpetBlock((DyeColor)color, (AbstractBlock.Properties)props), (IForgeRegistryEntry)original)).delegate);
            } else {
                flatBuilder.putDelegate((Enum)color, original.delegate);
            }
            fittedBuilder.putDelegate((Enum)color, ((FittedCarpetBlock)registry.register((IForgeRegistryEntry)new FittedCarpetBlock((DyeColor)color, (AbstractBlock.Properties)props.func_200942_a()), (String)new StringBuilder().append((String)color.func_176610_l()).append((String)"_fitted_carpet").toString())).delegate);
        }
        flatCarpets = flatBuilder.build();
        fitCarpets = fittedBuilder.build();
        if (((Boolean)Config.waterlogHopper.get()).booleanValue()) {
            dryHopper = (HopperBlock)registry.registerOverride(DryHopperBlock::new, Blocks.field_150438_bZ);
            wetHopper = (HopperBlock)registry.register((IForgeRegistryEntry)new WetHopperBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150438_bZ)), "wet_hopper");
        }
        cactus = (BlockCropBlock)registry.register((IForgeRegistryEntry)new CactusCropBlock(Blocks.field_150434_aF, PlantType.DESERT), "cactus");
        sugarCane = (BlockCropBlock)registry.register((IForgeRegistryEntry)new SugarCaneCropBlock(Blocks.field_196608_cF, PlantType.BEACH), "sugar_cane");
    }

    @SubscribeEvent
    void registerItem(RegistryEvent.Register<Item> event) {
        ItemRegistryAdapter registry = new ItemRegistryAdapter(event.getRegistry());
        Item.Properties decorationProps = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
        IForgeRegistry r = event.getRegistry();
        if (((Boolean)Config.enableFittedCarpets.get()).booleanValue()) {
            for (DyeColor color : DyeColor.values()) {
                Block carpet = (Block)InspirationsShared.VANILLA_CARPETS.get((Enum)color);
                BlockItem item = registry.registerBlockItem(carpet, decorationProps);
                Item.field_179220_a.put(carpet, item);
                Item.field_179220_a.put(Objects.requireNonNull(flatCarpets.get((Enum)color)), item);
            }
        }
        if (((Boolean)Config.waterlogHopper.get()).booleanValue()) {
            registry.register((IForgeRegistryEntry)new BlockItem((Block)dryHopper, new Item.Properties().func_200916_a(ItemGroup.field_78028_d)), (IForgeRegistryEntry)Items.field_221862_eo);
        }
        Item.Properties props = new Item.Properties().func_200916_a(ItemGroup.field_78039_h);
        cactusSeeds = (Item)registry.register((IForgeRegistryEntry)new SeedItem((Block)cactus, props), "cactus_seeds");
        sugarCaneSeeds = (Item)registry.register((IForgeRegistryEntry)new SeedItem((Block)sugarCane, props), "sugar_cane_seeds");
        heartbeet = (Item)registry.register((IForgeRegistryEntry)new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(2.4f).effect(() -> new EffectInstance(Effects.field_76428_l, 100), 1.0f).func_221453_d()), (Supplier<Boolean>)Config.enableHeartbeet), "heartbeet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        if (((Boolean)Config.waterlogHopper.get()).booleanValue()) {
            TileEntityType tileEntityType = TileEntityType.field_200987_r;
            synchronized (tileEntityType) {
                TileEntityType.field_200987_r.field_223046_I = new ImmutableSet.Builder().addAll((Iterable)TileEntityType.field_200987_r.field_223046_I).add((Object)dryHopper).add((Object)wetHopper).build();
            }
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        Ingredient heartbeet = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{InspirationsTweaks.heartbeet});
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new NormalBrewingRecipe(Potions.field_185230_b, heartbeet, Potions.field_185231_c, (Supplier<Boolean>)Config.brewHeartbeet));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new NormalBrewingRecipe(Potions.field_185233_e, heartbeet, Potions.field_185220_C, (Supplier<Boolean>)Config.brewHeartbeet));
        event.enqueueWork(this::registerCompostables);
        this.registerDispenserBehavior();
        MinecraftForge.EVENT_BUS.addListener((Consumer)new SmoothGrowthListener(Blocks.field_150434_aF, (Block)cactus));
        MinecraftForge.EVENT_BUS.addListener((Consumer)new SmoothGrowthListener(Blocks.field_196608_cF, (Block)sugarCane));
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new TweaksRecipeProvider(gen));
        }
    }

    @SubscribeEvent
    public static void loadLoot(LootTableLoadEvent event) {
        InspirationsTweaks.addToVanillaLoot(event, "entities/cave_spider");
        InspirationsTweaks.addToVanillaLoot(event, "entities/skeleton");
    }

    private void registerCompostables() {
        ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)cactusSeeds);
        ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)sugarCaneSeeds);
        ComposterBlock.func_220290_a((float)0.8f, (IItemProvider)heartbeet);
    }

    private void registerDispenserBehavior() {
        IDispenseItemBehavior behavior = (source, stack) -> {
            if (!((Boolean)Config.dispensersPlaceAnvils.get()).booleanValue()) {
                DEFAULT.dispense(source, stack);
            }
            Direction facing = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            ServerWorld world = source.func_197524_h();
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            DirectionalPlaceContext context = new DirectionalPlaceContext((World)world, pos, facing, stack, facing.func_176734_d());
            if (((BlockItem)stack.func_77973_b()).func_195942_a((BlockItemUseContext)context) == ActionResultType.SUCCESS) {
                return stack;
            }
            return DEFAULT.dispense(source, stack);
        };
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_150467_bQ, (IDispenseItemBehavior)behavior);
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_196717_eY, (IDispenseItemBehavior)behavior);
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_196718_eZ, (IDispenseItemBehavior)behavior);
    }

    static {
        fitCarpets = EnumObject.empty();
        flatCarpets = EnumObject.empty();
        DEFAULT = new DefaultDispenseItemBehavior();
    }
}

