/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.util;

import java.util.function.Consumer;
import java.util.function.Supplier;
import knightminer.inspirations.common.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class SmoothGrowthListener
implements Consumer<BlockEvent.CropGrowEvent.Pre> {
    private final Supplier<Block> crop;
    private final Supplier<Block> seed;

    public SmoothGrowthListener(Block crop, Block seed) {
        this.crop = crop.delegate;
        this.seed = seed.delegate;
    }

    @Override
    public void accept(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos dest;
        BlockPos source;
        BlockPos pos;
        if (!((Boolean)Config.smoothBlockCropGrowth.get()).booleanValue()) {
            return;
        }
        Block crop = this.crop.get();
        if (event.getState().func_177230_c() != crop) {
            return;
        }
        IWorld world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() == crop) {
            source = pos;
            dest = pos.func_177984_a();
        } else {
            source = pos.func_177977_b();
            dest = pos;
        }
        BlockState state = this.seed.get().func_176223_P();
        world.func_180501_a(dest, state, 3);
        if (world.func_180495_p(source).func_177230_c() == crop) {
            world.func_180501_a(source, crop.func_176223_P(), 4);
        }
        event.setResult(Event.Result.DENY);
        if (world instanceof World) {
            World casted = (World)world;
            state.func_215697_a(casted, dest, this.seed.get(), source, false);
            ForgeHooks.onCropsGrowPost((World)casted, (BlockPos)source, (BlockState)state);
        }
    }
}

