/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility;

import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.common.item.HidableBlockItem;
import knightminer.inspirations.utility.block.CarpetedPressurePlateBlock;
import knightminer.inspirations.utility.block.CarpetedTrapdoorBlock;
import knightminer.inspirations.utility.block.CollectorBlock;
import knightminer.inspirations.utility.block.PipeBlock;
import knightminer.inspirations.utility.block.TorchLeverBlock;
import knightminer.inspirations.utility.block.TorchLeverWallBlock;
import knightminer.inspirations.utility.datagen.UtilityRecipeProvider;
import knightminer.inspirations.utility.inventory.CollectorContainer;
import knightminer.inspirations.utility.inventory.PipeContainer;
import knightminer.inspirations.utility.item.TorchLeverItem;
import knightminer.inspirations.utility.tileentity.CollectorTileEntity;
import knightminer.inspirations.utility.tileentity.PipeTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.ContainerTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.adapter.TileEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsUtility
extends ModuleBase {
    public static Block torchLeverWall;
    public static Block torchLeverFloor;
    public static Block soulLeverWall;
    public static Block soulLeverFloor;
    public static EnumObject<DyeColor, CarpetedTrapdoorBlock> carpetedTrapdoors;
    public static EnumObject<DyeColor, CarpetedPressurePlateBlock> carpetedPressurePlates;
    public static Block collector;
    public static Block pipe;
    public static Item torchLeverItem;
    public static Item soulLeverItem;
    public static TileEntityType<CollectorTileEntity> tileCollector;
    public static TileEntityType<PipeTileEntity> tilePipe;
    public static ContainerType<CollectorContainer> contCollector;
    public static ContainerType<PipeContainer> contPipe;
    private final DispenserRegAccess dispenserReg = new DispenserRegAccess();

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistryAdapter registry = new BlockRegistryAdapter(event.getRegistry());
        IForgeRegistry r = event.getRegistry();
        torchLeverFloor = (Block)registry.register((IForgeRegistryEntry)new TorchLeverBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150478_aa).func_200947_a(SoundType.field_185848_a), (IParticleData)ParticleTypes.field_197631_x), "torch_lever");
        torchLeverWall = (Block)registry.register((IForgeRegistryEntry)new TorchLeverWallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196591_bQ).lootFrom(() -> torchLeverFloor), (IParticleData)ParticleTypes.field_197631_x), "wall_torch_lever");
        soulLeverFloor = (Block)registry.register((IForgeRegistryEntry)new TorchLeverBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235339_cQ_), (IParticleData)ParticleTypes.field_239811_B_), "soul_torch_lever");
        soulLeverWall = (Block)registry.register((IForgeRegistryEntry)new TorchLeverWallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_235340_cR_).lootFrom(() -> soulLeverFloor), (IParticleData)ParticleTypes.field_239811_B_), "wall_soul_torch_lever");
        carpetedTrapdoors = registry.registerEnum(color -> new CarpetedTrapdoorBlock(), (Enum[])DyeColor.values(), "carpeted_trapdoor");
        carpetedPressurePlates = registry.registerEnum(CarpetedPressurePlateBlock::new, (Enum[])DyeColor.values(), "carpeted_pressure_plate");
        collector = (Block)registry.register((IForgeRegistryEntry)new CollectorBlock(), "collector");
        pipe = (Block)registry.register((IForgeRegistryEntry)new PipeBlock(), "pipe");
    }

    @SubscribeEvent
    public void registerTEs(RegistryEvent.Register<TileEntityType<?>> event) {
        TileEntityTypeRegistryAdapter registry = new TileEntityTypeRegistryAdapter(event.getRegistry());
        tileCollector = registry.register(CollectorTileEntity::new, collector, "collector");
        tilePipe = registry.register(PipeTileEntity::new, pipe, "pipe");
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        ContainerTypeRegistryAdapter registry = new ContainerTypeRegistryAdapter(event.getRegistry());
        IForgeRegistry r = event.getRegistry();
        contCollector = registry.registerType(CollectorContainer::new, "collector");
        contPipe = registry.registerType(PipeContainer::new, "pipe");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item.Properties props = new Item.Properties().func_200916_a(ItemGroup.field_78028_d);
        ItemRegistryAdapter registry = new ItemRegistryAdapter(event.getRegistry(), props);
        torchLeverItem = (Item)registry.register((IForgeRegistryEntry)new TorchLeverItem(torchLeverFloor, torchLeverWall, props), "torch_lever");
        soulLeverItem = (Item)registry.register((IForgeRegistryEntry)new TorchLeverItem(soulLeverFloor, soulLeverWall, props), "soul_torch_lever");
        registry.registerBlockItem(carpetedTrapdoors, block -> new HidableBlockItem((Block)block, props));
        registry.registerDefaultBlockItem(collector);
        registry.registerDefaultBlockItem(pipe);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new UtilityRecipeProvider(gen));
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        this.registerDispenserBehavior();
    }

    private void registerDispenserBehavior() {
    }

    static {
        carpetedTrapdoors = EnumObject.empty();
        carpetedPressurePlates = EnumObject.empty();
    }

    private static class DispenserRegAccess
    extends DispenserBlock {
        DispenserRegAccess() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151579_a));
        }

        IDispenseItemBehavior getRegisteredBehaviour(Item item) {
            return super.func_149940_a(new ItemStack((IItemProvider)item));
        }
    }
}

