/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import knightminer.inspirations.shared.InspirationsShared;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class CarpetedPressurePlateBlock
extends PressurePlateBlock {
    private static final VoxelShape PRESSED_AABB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.25, (double)15.0));
    private static final VoxelShape UNPRESSED_AABB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0));
    private final DyeColor color;
    private final String transKey;

    public CarpetedPressurePlateBlock(DyeColor color) {
        super(PressurePlateBlock.Sensitivity.MOBS, AbstractBlock.Properties.func_200952_a((Material)Material.field_151593_r, (DyeColor)color).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g));
        this.color = color;
        this.transKey = String.format("block.minecraft.%s_carpet", color.func_176762_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean flag = this.func_176576_e(state) > 0;
        return flag ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public String func_149739_a() {
        return this.transKey;
    }

    public IItemProvider getCarpet() {
        return (IItemProvider)InspirationsShared.VANILLA_CARPETS.get((Enum)this.color);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack(this.getCarpet());
    }
}

