/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.tileentity.PipeTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DropperBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import slimeknights.mantle.block.InventoryBlock;

public class PipeBlock
extends InventoryBlock
implements IHidable,
IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    private static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    private static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    private static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    private static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    private static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final BooleanProperty HOPPER = BooleanProperty.func_177716_a((String)"hopper");
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty[] DIR_ENABLED = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final VoxelShape BOUNDS_CENTER = VoxelShapes.func_197873_a((double)0.375, (double)0.25, (double)0.375, (double)0.625, (double)0.5, (double)0.625);
    private static final VoxelShape BOUNDS_DOWN = VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.25, (double)0.625);
    private static final VoxelShape BOUNDS_UP = VoxelShapes.func_197873_a((double)0.375, (double)0.5, (double)0.375, (double)0.625, (double)1.0, (double)0.625);
    private static final VoxelShape BOUNDS_NORTH = VoxelShapes.func_197873_a((double)0.375, (double)0.25, (double)0.0, (double)0.625, (double)0.5, (double)0.375);
    private static final VoxelShape BOUNDS_SOUTH = VoxelShapes.func_197873_a((double)0.375, (double)0.25, (double)0.625, (double)0.625, (double)0.5, (double)1.0);
    private static final VoxelShape BOUNDS_WEST = VoxelShapes.func_197873_a((double)0.0, (double)0.25, (double)0.375, (double)0.375, (double)0.5, (double)0.625);
    private static final VoxelShape BOUNDS_EAST = VoxelShapes.func_197873_a((double)0.625, (double)0.25, (double)0.375, (double)1.0, (double)0.5, (double)0.625);
    private static final VoxelShape BOUNDS_DOWN_CONNECT = VoxelShapes.func_197873_a((double)0.34375, (double)0.0, (double)0.34375, (double)0.65625, (double)0.0625, (double)0.65625);
    private static final VoxelShape BOUNDS_UP_CONNECT = VoxelShapes.func_197873_a((double)0.34375, (double)0.9375, (double)0.34375, (double)0.65625, (double)1.0, (double)0.65625);
    private static final VoxelShape BOUNDS_NORTH_CONNECT = VoxelShapes.func_197873_a((double)0.34375, (double)0.21875, (double)0.0, (double)0.65625, (double)0.53125, (double)0.0625);
    private static final VoxelShape BOUNDS_SOUTH_CONNECT = VoxelShapes.func_197873_a((double)0.34375, (double)0.21875, (double)0.9375, (double)0.65625, (double)0.53125, (double)1.0);
    private static final VoxelShape BOUNDS_WEST_CONNECT = VoxelShapes.func_197873_a((double)0.0, (double)0.21875, (double)0.34375, (double)0.0625, (double)0.53125, (double)0.65625);
    private static final VoxelShape BOUNDS_EAST_CONNECT = VoxelShapes.func_197873_a((double)0.9375, (double)0.21875, (double)0.34375, (double)1.0, (double)0.53125, (double)0.65625);
    private static final VoxelShape[][] BOUNDS = new VoxelShape[6][64];

    public PipeBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(3.0f, 8.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HOPPER, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enablePipe.get();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.shouldAddtoItemGroup(group)) {
            super.func_149666_a(group, stacks);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, FACING, NORTH, EAST, SOUTH, WEST, UP, DOWN, HOPPER});
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction neighFacing, BlockState neighState, IWorld world, BlockPos pos, BlockPos neighPos) {
        Direction outFacing = (Direction)state.func_177229_b((Property)FACING);
        state = (BlockState)state.func_206870_a((Property)DIR_ENABLED[neighFacing.func_176745_a()], (Comparable)Boolean.valueOf(PipeBlock.canConnectTo(world, pos, outFacing, neighFacing)));
        if (outFacing == neighFacing) {
            BlockState offsetState = world.func_180495_p(pos.func_177972_a(outFacing));
            state = (BlockState)state.func_206870_a((Property)HOPPER, (Comparable)Boolean.valueOf(offsetState.func_177230_c() instanceof HopperBlock && offsetState.func_177229_b((Property)HopperBlock.field_176430_a) != outFacing.func_176734_d()));
        }
        return state;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l().func_176734_d();
        if (!((Boolean)Config.pipeUpwards.get()).booleanValue() && facing == Direction.UP) {
            facing = context.func_195992_f();
        }
        BlockState offsetState = world.func_180495_p(pos.func_177972_a(facing));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)HOPPER, (Comparable)Boolean.valueOf(offsetState.func_177230_c() instanceof HopperBlock && offsetState.func_177229_b((Property)HopperBlock.field_176430_a) != facing.func_176734_d()))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((IWorld)world, pos, facing, Direction.UP)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((IWorld)world, pos, facing, Direction.DOWN)))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((IWorld)world, pos, facing, Direction.NORTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((IWorld)world, pos, facing, Direction.EAST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((IWorld)world, pos, facing, Direction.SOUTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((IWorld)world, pos, facing, Direction.WEST)));
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (item == InspirationsUtility.pipe.func_199767_j() || Block.func_149634_a((Item)item) instanceof HopperBlock) {
            return ActionResultType.PASS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, trace);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = world.func_175625_s(pos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private static boolean canConnectTo(IWorld world, BlockPos pos, Direction facing, Direction side) {
        if (facing == side) {
            return false;
        }
        BlockState state = world.func_180495_p(pos.func_177972_a(side));
        Block block = state.func_177230_c();
        Direction opposite = side.func_176734_d();
        if ((block instanceof PipeBlock || block instanceof DropperBlock) && state.func_177229_b((Property)FACING) == opposite) {
            return true;
        }
        return side != Direction.DOWN && block instanceof HopperBlock && state.func_177229_b((Property)HopperBlock.field_176430_a) == opposite;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PipeTileEntity();
    }

    protected boolean openGui(PlayerEntity player, World world, BlockPos pos) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new AssertionError((Object)"Needs to be server!");
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PipeTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            return true;
        }
        return false;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        TileEntity te;
        if (pos.func_177972_a((Direction)state.func_177229_b((Property)FACING)).equals((Object)neighbor) && (te = world.func_175625_s(pos)) instanceof PipeTileEntity) {
            ((PipeTileEntity)te).clearCachedInventories();
        }
        super.func_220069_a(state, world, pos, blockIn, neighbor, isMoving);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        int bitmask = 0;
        for (int i = 0; i < 6; ++i) {
            bitmask |= (Boolean)state.func_177229_b((Property)DIR_ENABLED[i]) != false ? 1 << i : 0;
        }
        return BOUNDS[((Direction)state.func_177229_b((Property)FACING)).func_176745_a()][bitmask];
    }

    static {
        VoxelShape[] BOUNDS_SIDES = new VoxelShape[]{BOUNDS_DOWN, BOUNDS_UP, BOUNDS_NORTH, BOUNDS_SOUTH, BOUNDS_WEST, BOUNDS_EAST};
        VoxelShape[] BOUNDS_CONN_SIDES = new VoxelShape[]{BOUNDS_DOWN_CONNECT, BOUNDS_UP_CONNECT, BOUNDS_NORTH_CONNECT, BOUNDS_SOUTH_CONNECT, BOUNDS_WEST_CONNECT, BOUNDS_EAST_CONNECT};
        for (int i = 0; i < 64; ++i) {
            int j;
            VoxelShape shape = BOUNDS_CENTER;
            for (j = 0; j < 6; ++j) {
                if ((i & 1 << j) == 0) continue;
                shape = VoxelShapes.func_216384_a((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{BOUNDS_CONN_SIDES[j], BOUNDS_SIDES[j]});
            }
            for (j = 0; j < 6; ++j) {
                PipeBlock.BOUNDS[j][i] = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)BOUNDS_SIDES[j]);
            }
        }
    }
}

