/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen;

import com.daderpduck.seamless_loading_screen.SeamlessLoadingScreen;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;

public class ScreenshotLoader {
    public static final ResourceLocation SCREENSHOT = new ResourceLocation("seamless_loading_screen", "screenshot");
    private static float imageRatio = 1.0f;
    private static boolean loaded = false;
    private static Path filePath;
    private static final Pattern RESERVED_FILENAMES_PATTERN;

    public static void setScreenshotWorld(String worldName) {
        ScreenshotLoader.setScreenshot("screenshots/worlds/singleplayer/" + worldName + ".png");
    }

    public static void setScreenshotServer(String address, int port) {
        ScreenshotLoader.setScreenshot("screenshots/worlds/servers/" + address + "_" + port + ".png");
    }

    public static void setScreenshotRealm(String realmName) {
        ScreenshotLoader.setScreenshot("screenshots/worlds/realms/" + ScreenshotLoader.cleanFileName(realmName) + ".png");
    }

    private static void setScreenshot(String screenshotPath) {
        loaded = false;
        filePath = Paths.get(Minecraft.func_71410_x().field_71412_D.getPath(), screenshotPath);
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(filePath.toFile());){
                NativeImage image = NativeImage.func_195713_a((InputStream)in);
                imageRatio = (float)image.func_195702_a() / (float)image.func_195714_b();
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(SCREENSHOT, (Texture)new DynamicTexture(image));
                loaded = true;
                SeamlessLoadingScreen.LOGGER.info("Screenshot loaded at {}", (Object)filePath);
            }
            catch (IOException e) {
                SeamlessLoadingScreen.LOGGER.error("Failed to read screenshot", (Throwable)e);
            }
        } else {
            SeamlessLoadingScreen.LOGGER.warn("Screenshot path doesn't exist or is not a file {}", (Object)filePath);
        }
    }

    private static String cleanFileName(String fileName) {
        for (char c : SharedConstants.field_71567_b) {
            fileName = fileName.replace(c, '_');
        }
        if (RESERVED_FILENAMES_PATTERN.matcher(fileName = fileName.replaceAll("[./\"]", "_")).matches()) {
            fileName = "_" + fileName + "_";
        }
        if (fileName.length() > 251) {
            fileName = fileName.substring(0, 251);
        }
        return fileName;
    }

    public static float getImageRatio() {
        return imageRatio;
    }

    public static Path getCurrentScreenshotPath() {
        return filePath;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void resetState() {
        loaded = false;
    }

    static {
        RESERVED_FILENAMES_PATTERN = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);
    }
}

