/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen.events;

import com.daderpduck.seamless_loading_screen.ScreenshotLoader;
import com.daderpduck.seamless_loading_screen.ScreenshotRenderer;
import com.daderpduck.seamless_loading_screen.ScreenshotTaker;
import com.daderpduck.seamless_loading_screen.SeamlessLoadingScreen;
import com.daderpduck.seamless_loading_screen.config.Config;
import com.daderpduck.seamless_loading_screen.events.DeleteSaveEvent;
import com.daderpduck.seamless_loading_screen.events.PreLoadWorldEvent;
import com.daderpduck.seamless_loading_screen.events.PreUnloadWorldEvent;
import com.daderpduck.seamless_loading_screen.events.RealmsJoinEvent;
import com.daderpduck.seamless_loading_screen.events.UpdatePlayerLookEvent;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.DisconnectedScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="seamless_loading_screen")
public class EventHandler {
    private static boolean takenScreenshot = false;

    @SubscribeEvent
    public static void initGuiEvent(GuiScreenEvent.InitGuiEvent event) {
        Screen screen = event.getGui();
        Minecraft mc = Minecraft.func_71410_x();
        if (screen instanceof ConnectingScreen) {
            ServerData serverData = mc.func_147104_D();
            if (serverData == null) {
                return;
            }
            Minecraft.func_71410_x().field_71417_B.func_241563_k_();
            ServerAddress serveraddress = ServerAddress.func_78860_a((String)serverData.field_78845_b);
            ScreenshotLoader.setScreenshotServer(serveraddress.func_78861_a(), serveraddress.func_78864_b());
        } else if (screen instanceof DisconnectedScreen) {
            ScreenshotLoader.resetState();
        } else if (screen instanceof RealmsGenericErrorScreen) {
            ScreenshotLoader.resetState();
        }
    }

    @SubscribeEvent
    public static void onWorldJoin(PreLoadWorldEvent event) {
        Minecraft.func_71410_x().field_71417_B.func_241563_k_();
        ScreenshotLoader.setScreenshotWorld(event.worldName);
        ScreenshotTaker.shouldSaveScreenshot(true);
    }

    @SubscribeEvent
    public static void onRealmsJoin(RealmsJoinEvent event) {
        Minecraft.func_71410_x().field_71417_B.func_241563_k_();
        ScreenshotLoader.setScreenshotRealm(event.realmsServer.field_230584_c_);
        ScreenshotTaker.shouldSaveScreenshot(true);
    }

    @SubscribeEvent
    public static void onUnloadWorld(PreUnloadWorldEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!takenScreenshot && mc.field_71441_e != null) {
            ScreenshotTaker.takeScreenshot(ignored -> {
                takenScreenshot = true;
                mc.func_213231_b(event.nextScreen);
            });
            ScreenshotLoader.resetState();
            event.setCanceled(true);
        } else {
            takenScreenshot = false;
        }
    }

    @SubscribeEvent
    public static void onMouseMove(UpdatePlayerLookEvent event) {
        if (ScreenshotRenderer.Fader.isFading() && ((Boolean)Config.DisableCamera.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (ScreenshotLoader.isLoaded()) {
            ScreenshotRenderer.renderScreenshot(event.getGui().field_230709_l_, event.getGui().field_230708_k_, 255);
        }
    }

    @SubscribeEvent
    public static void onSaveDelete(DeleteSaveEvent event) {
        ScreenshotLoader.setScreenshotWorld(event.saveDir.getFileName().toString());
        Path screenshotPath = ScreenshotLoader.getCurrentScreenshotPath();
        try {
            SeamlessLoadingScreen.LOGGER.info("Deleting screenshot at {}", (Object)screenshotPath);
            Files.deleteIfExists(screenshotPath);
        }
        catch (IOException e) {
            SeamlessLoadingScreen.LOGGER.error("Failed to delete screenshot", (Throwable)e);
        }
        ScreenshotLoader.resetState();
    }

    @SubscribeEvent
    public static void onRenderTickEnd(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (ScreenshotLoader.isLoaded() && mc.field_71462_r == null) {
            float alpha = ScreenshotRenderer.Fader.getAlpha();
            if (alpha > 0.0f) {
                int scaledHeight = mc.func_228018_at_().func_198087_p();
                int scaledWidth = mc.func_228018_at_().func_198107_o();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableAlphaTest();
                ScreenshotRenderer.renderScreenshot(scaledHeight, scaledWidth, (int)(alpha * 255.0f));
                RenderSystem.enableAlphaTest();
                RenderSystem.disableBlend();
                if (ScreenshotRenderer.Fader.isHolding() && mc.field_71462_r == null) {
                    AbstractGui.func_238472_a_((MatrixStack)new MatrixStack(), (FontRenderer)mc.field_71466_p, (ITextComponent)new TranslationTextComponent("multiplayer.downloadingTerrain"), (int)(scaledWidth / 2), (int)70, (int)0xFFFFFF);
                }
                ScreenshotRenderer.Fader.tick(event.renderTickTime);
            } else {
                ScreenshotRenderer.Fader.reset();
                ScreenshotLoader.resetState();
            }
        }
    }
}

