/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.inventory.SlotFilter;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.fluid.Fluid;
import cam72cam.mod.fluid.FluidTank;
import cam72cam.mod.fluid.ITank;
import cam72cam.mod.gui.GuiRegistry;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.serialization.StrictTagMapper;
import cam72cam.mod.serialization.TagField;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;

public abstract class FreightTank
extends Freight {
    @TagField(value="tank")
    public final FluidTank theTank = new FluidTank(null, 0);
    @TagSync
    @TagField(value="FLUID_AMOUNT")
    private int fluidAmount = 0;
    @TagSync
    @TagField(value="FLUID_TYPE", mapper=StrictTagMapper.class)
    private String fluidType = null;

    public abstract FluidQuantity getTankCapacity();

    @Nullable
    public abstract List<Fluid> getFluidFilter();

    protected int[] getContainerInputSlots() {
        return new int[]{0};
    }

    protected int[] getContainertOutputSlots() {
        int[] result = new int[this.getInventorySize()];
        for (int i = 0; i < this.getInventorySize(); ++i) {
            result[i] = i;
        }
        for (int i : this.getContainerInputSlots()) {
            result = ArrayUtils.removeElement((int[])result, (int)i);
        }
        return result;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    public int getLiquidAmount() {
        return this.fluidAmount;
    }

    public Fluid getLiquid() {
        if (this.fluidType == null) {
            return null;
        }
        return Fluid.getFluid((String)this.fluidType);
    }

    @Override
    protected void initContainerFilter() {
        this.cargoItems.filter.clear();
        this.cargoItems.filter.put(0, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.filter.put(1, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.defaultFilter = SlotFilter.NONE;
    }

    @Override
    public void onAssemble() {
        super.onAssemble();
        this.theTank.setCapacity(this.getTankCapacity().MilliBuckets());
        this.theTank.setFilter(this::getFluidFilter);
        this.theTank.onChanged(this::onTankContentsChanged);
        this.onTankContentsChanged();
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.theTank.setCapacity(0);
        this.onTankContentsChanged();
    }

    protected void onTankContentsChanged() {
        if (this.getWorld().isClient) {
            return;
        }
        this.fluidAmount = this.theTank.getContents().getAmount();
        this.fluidType = this.theTank.getContents().getFluid() == null ? null : this.theTank.getContents().getFluid().ident;
    }

    public int getServerLiquidAmount() {
        return this.theTank.getContents().getAmount();
    }

    @Override
    public GuiRegistry.EntityGUI guiType() {
        return GuiTypes.TANK;
    }

    @Override
    public void onTick() {
        super.onTick();
        this.checkInvent();
    }

    protected void checkInvent() {
        if (this.getWorld().isClient) {
            return;
        }
        if (!this.isBuilt()) {
            return;
        }
        if (this.cargoItems.getSlotCount() == 0) {
            return;
        }
        for (int inputSlot : this.getContainerInputSlots()) {
            ItemStack input = this.cargoItems.get(inputSlot);
            ItemStack[] inputCopy = new ItemStack[]{input.copy()};
            inputCopy[0].setCount(1);
            ITank inputTank = ITank.getTank((ItemStack)inputCopy[0], stack -> {
                inputCopy[0] = stack;
            });
            if (inputTank == null || input.getCount() <= 0) continue;
            block1: for (Boolean doFill : new Boolean[]{false, true}) {
                boolean success;
                if (doFill.booleanValue()) {
                    success = this.theTank.drain(inputTank, this.theTank.getCapacity(), true) > 0;
                } else {
                    boolean bl = success = this.theTank.fill(inputTank, this.theTank.getCapacity(), true) > 0;
                }
                if (!success) continue;
                ItemStack out = inputCopy[0].copy();
                int[] nArray = this.getContainertOutputSlots();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer slot = nArray[i];
                    if (this.cargoItems.insert(slot, out, true).getCount() != 0) continue;
                    if (doFill.booleanValue()) {
                        this.theTank.drain(inputTank, this.theTank.getCapacity(), false);
                    } else {
                        this.theTank.fill(inputTank, this.theTank.getCapacity(), false);
                    }
                    if (Config.ConfigDebug.debugInfiniteLiquids) continue;
                    this.cargoItems.extract(inputSlot, 1, false);
                    this.cargoItems.insert(slot, out, false);
                    continue block1;
                }
            }
        }
    }

    @Override
    public double getWeight() {
        double fLoad = super.getWeight();
        if (this.getLiquidAmount() > 0) {
            fLoad += (double)(this.getLiquidAmount() * this.getLiquid().getDensity() / 1000);
        }
        return fLoad;
    }

    public int getPercentLiquidFull() {
        return this.getLiquidAmount() * 100 / this.getTankCapacity().MilliBuckets();
    }
}

